/**
 * @author Deepak S
 */
Ext.define('Academia.store.facilitiesresources.managegallery.FileUploadWindowDataviewStore', {
    extend: 'Ext.data.Store',
    fields: [
        { name:'path', type:'string' },
        { name:'imageName', type:'string' },
        { name:'fileType'},
        { name:'fileData'},
        { name:'documentId'},
        { 
        	name:'iconImage', 
        	convert : function (v, rec) {
        		if(!isNullOrEmpty(rec.get('fileType'))){
        			try{
        				if(rec.data.fileType.toLowerCase() == "odt"){
        					return "resources/images/driveToolImages/odt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "doc" || rec.data.fileType.toLowerCase() == "docx"){
        					return "resources/images/driveToolImages/doc.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "pdf"){
        					return "resources/images/driveToolImages/pdf.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "ppt" || rec.data.fileType.toLowerCase() == "pptx"){
        					return "resources/images/driveToolImages/ppt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "txt"){
        					return "resources/images/driveToolImages/txt.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "xls" || rec.data.fileType.toLowerCase() == "xlsx"){
        					return "resources/images/driveToolImages/xls.png";
        				}
        				else if(rec.data.fileType.toLowerCase() == "zip" || rec.data.fileType.toLowerCase() == "zipx"){
        					return "resources/images/driveToolImages/zip.svg";
        				}
        				else{
        					return v;
        				}
        			}
        			catch(e){
            			return null;
        			}
        		}else{
        			return null;
        		}
        	}
        }
    ]
});
