/**
 * This store is used for student fee and payment dashboard report tree panel
 * @author Bhanu Pratap Singh
 * @author Rajkumar Patidar
 */
Ext.define('Academia.store.feeandpayment.dashboardAndReports.StudentFeeAndPaymentReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text','permissionKey'],
	root: {
        success: true,
        children: [{
			text: getFeeAndPaymentCommonTranslation('STUDENT_FEE_REPORT'),
			reportXtype: '',
			reportXtypeItemId: '',
		    leaf: false,
		    expanded: true,
		    children: [{
		    	text: getFeeAndPaymentCommonTranslation('CONSOLIDATED'),
		    	reportXtype: 'studentfeereportstructure',
		    	reportXtypeItemId: 'studentfeereportstructure',
		    	permissionKey: 'FEE_CONSOLIDATED_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('COLLECTION'),
		    	reportXtype: 'studentcollectionreportstructure',
		    	reportXtypeItemId: 'studentcollectionreportstructure',
		    	permissionKey: 'FEE_COLLECTION_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('OUTSTANDING'),
		    	reportXtype: 'studentoutstandingreportstructure',
		    	reportXtypeItemId: 'studentoutstandingreportstructure',
		    	permissionKey: 'FEE_OUTSTANDING_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('DISCOUNT'),
		    	reportXtype: 'studentdiscountreportstructure',
		    	reportXtypeItemId: 'studentdiscountreportstructure',
		    	permissionKey: 'FEE_DISCOUNT_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('STUDENT_FEE_HEAD_WISE'),
		    	reportXtype: 'feeheadwisecollectionreportstructure',
		    	reportXtypeItemId: 'feeheadwisecollectionreportstructure',
		    	permissionKey: 'FEE_STUDENT_FEE_HEAD_WISE_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('FEE_RULE_ASSOCIATION_REPORT'),
		    	reportXtype: 'feeruleassociationreportstructure',
		    	reportXtypeItemId: 'feeruleassociationreportstructure',
		    	permissionKey: 'FEE_RULE_ASSOCIATION_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_REPORT'),
		    	reportXtype: 'paymentplanreportstructure',
		    	reportXtypeItemId: 'paymentplanreportstructure',
		    	permissionKey: 'PAYMENT_PLAN_REPORT',
		        leaf: true
		    }]
		},{
			text: getFeeAndPaymentCommonTranslation('PROGRAM_FEE_REPORT'),
			reportXtype: '',
			reportXtypeItemId: '',
		    leaf: false,
		    expanded: true,
		    children: [{
		    	text: getFeeAndPaymentCommonTranslation('PROGRAM_FEE_REPORT'),
		    	reportXtype: 'programwisefeereportstructure',
		    	reportXtypeItemId: 'programwisefeereportstructure',
		    	permissionKey: 'FEE_PROGRAM_FEE_REPORT',
		        leaf: true
		    },
		    {
		    	text: getCommonTranslation('COURSE_FEE_DEFINITION_MAPPING'),
		    	reportXtype: 'coursewisefeereportstructure',
		    	reportXtypeItemId: 'coursewisefeereportstructure',
		    	permissionKey: 'COURSE_FEE_DEFINATION_MAPPING_PERMISSIONS',
		        leaf: true
		    }]
		},{
			text: getFeeAndPaymentCommonTranslation('OTHER_FEE_REPORT'),
			reportXtype: '',
			reportXtypeItemId: '',
		    leaf: false,
		    expanded: true,
		    children: [{
		    	text: getFeeAndPaymentCommonTranslation('USERWISE_COLLECTION'),
		    	reportXtype: 'userwisecollectionreportstructure',
		    	reportXtypeItemId: 'userwisecollectionreportstructure',
		    	permissionKey: 'FEE_USERWISE_COLLECTION_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('RECEIPTS_WITH_HEAD_DETAILS'),
		    	reportXtype: 'receiptwithheadreportstructure',
		    	reportXtypeItemId: 'receiptwithheadreportstructure',
		    	permissionKey: 'FEE_RECEIPTS_WITH_HEAD_DETAILS_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAIL_REPORT'),
		    	reportXtype: 'instrumentdetailreportstructure',
		    	reportXtypeItemId: 'instrumentdetailreportstructure',
		    	permissionKey: 'FEE_INSTRUMENT_DETAIL_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_COLLECTION'),
		    	reportXtype: 'dependentfeecollectionreportstructure',
		    	reportXtypeItemId: 'dependentfeecollectionreportstructure',
		    	permissionKey: 'FEE_DEPENDENT_FEE_COLLECTION_REPORT',
		        leaf: true
		    }]
		},{
			text: getFeeAndPaymentCommonTranslation('APPLICANT_FEE_REPORT'),
			reportXtype: '',
			reportXtypeItemId: '',
		    leaf: false,
		    expanded: true,
		    children: [{
		    	text: getFeeAndPaymentCommonTranslation('APPLICANT_CONSOLIDATED'),
		    	reportXtype: 'applicantfeereportstructure',
		    	reportXtypeItemId: 'applicantfeereportstructure',
		    	permissionKey: 'FEE_APPLICANT_CONSOLIDATED_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('APPLICANT_COLLECTION'),
		    	reportXtype: 'applicantfeereportcollectionstructure',
		    	reportXtypeItemId: 'applicantfeereportcollectionstructure',
		    	permissionKey: 'FEE_APPLICANT_COLLECTION_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('APPLICANT_OUTSTANDING'),
		    	reportXtype: 'applicantoutstandingreportstructure',
		    	reportXtypeItemId: 'applicantoutstandingreportstructure',
		    	permissionKey: 'FEE_APPLICANT_OUTSTANDING_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('APPLICANT_DISCOUNT'),
		    	reportXtype: 'applicantdiscountreportstructure',
		    	reportXtypeItemId: 'applicantdiscountreportstructure',
		    	permissionKey: 'FEE_APPLICANT_DISCOUNT_REPORT',
		        leaf: true
		    },{
		    	text: getFeeAndPaymentCommonTranslation('APPLIACNT_HEAD_WISE'),
		    	reportXtype: 'applicantfeeheadwisecollectionreportstructure',
		    	reportXtypeItemId: 'applicantfeeheadwisecollectionreportstructure',
		    	permissionKey: 'FEE_APPLIACNT_HEAD_WISE_REPORT',
		        leaf: true
		    }]
		}]
    //}]
	}
});

