Ext.define('Academia.store.messaging.RecipientTypeByEventId', {
     extend: 'Ext.data.Store',
     model: 'Academia.model.messaging.DataProviderModel',
     autoLoad: false,
     sorters: [{
         property: 'code',
         direction: 'ASC'
     }],
     sortOnLoad: true,
     remoteSort: false,
     proxy: {
         type: 'rest',
         api: {        	 
             read: SERVERURL.FIND_ALL_RECIPIENT_TYPES_BY_EVENT_ID      //URL -rest/msgRecipientTypeResource/findAllBySysMsgEventId?id=# 
         },
         reader: {
             type: 'json'
         }
     },
     listeners: {
         load: {
             element: 'el',
             fn: function(store, records, successful, eOpts) {                 
                 for (var count = 0; count < records.length; count++) {
                     var record = records[count];
                     var resultKey=record.get('code');
                     if(!isNullOrEmpty(resultKey)){
                    	 records[count].set('code', getMessagingModuleTranslation(resultKey));
                     }                     
                 }
                 store.commitChanges();
             }
         }
     }
 });