/**
 * @author Varsha Gour
 */
Ext.define('Academia.store.reports.servicerequest.FacultyLeaveDashBoardTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text', 'permissionKey'],
	root: {
        success: true,
        children: [{
        	text: getServiceRequestTranslation('SELECT_DASHBOARD_AND_REPORT'),
        	reportXtype: '',
        	reportXtypeItemId: '',
            leaf: false,
            expanded: true,
            children: [{
            	text: getServiceRequestTranslation('EMPLOYEE_LEAVE_REPORT'),
            	reportXtype: 'lmemployeeleavereportstructure',
            	reportXtypeItemId: 'lmemployeeleavereportstructure',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_REPORT',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('LEAVE_SLA_REPORT'),
            	reportXtype: 'lmleaveslareportstructure',
            	reportXtypeItemId: 'lmleaveslareportstructureItemId',
            	permissionKey: 'PERMISSION_LEAVE_SLA_REPORT',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('LEAVE_APPROVAL_FLOW_REPORT'),
            	reportXtype: 'lmleaveapprovalflowreportstructure',
            	reportXtypeItemId: 'lmleaveapprovalflowreportstructureItemId',
            	permissionKey: 'PERMISSION_LEAVE_APPROVAL_FLOW_REPORT',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('EMPLOYEE_LEAVE_BALANCE_REPORT'),
            	reportXtype: 'lmemployeeleavebalancereportstructure',
            	reportXtypeItemId: 'lmemployeeleavebalancereportstructureItemId',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_BALANCE_REPORT',
                leaf: true
            }, {
            	text: getPersonModuleTranslation('EMPLOYEE_LEAVE_ENCASHMENT_REPORT'),
            	reportXtype: 'lmleaveencashmentreportstructure',
            	reportXtypeItemId: 'lmleaveencashmentreportstructureItemId',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_ENCASHMENT_REPORT',
                leaf: true
            },{
            	text: getPersonModuleTranslation('EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT'),
            	reportXtype: 'lmleavecarryforwardreportstructure',
            	reportXtypeItemId: 'lmleavecarryforwardreportstructureItemId',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT',
                leaf: true
            },{
            	text: getPersonModuleTranslation('EMPLOYEE_LEAVE_LAPSE_REPORT'),
            	reportXtype: 'lmleavelapsereportstructure',
            	reportXtypeItemId: 'lmleavelapsereportstructureItemId',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_LAPSE_REPORT',
                leaf: true
            },{
            	text: getPersonModuleTranslation('EMPLOYEE_LEAVE_CREDIT_REPORT'),
            	reportXtype: 'lmleavecreditreportstructure',
            	reportXtypeItemId: 'lmleavecreditreportstructureItemId',
            	permissionKey: 'PERMISSION_EMPLOYEE_LEAVE_CREDIT_REPORT',
                leaf: true
            }]
        }]
    }
});