/**
 * @author Rohit Sharma
 */
Ext.define('Academia.store.student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesGridStore', {
    extend: 'Ext.data.Store',
    fields: [
    	'batch',
    	'period',
    	'academicTerm',
    	'academicSubTopics',
    	'academicTopics',
    	'programId',
    	'programName',
    	'uploadedZipFilePath',
    	'logFilePath',
    	'uploadedBy',
    	'uploadedOn',
    	{
    		name: 'logFileName',
    		convert: function(val, rec) {
    			var str = rec.get('logFilePath');
				if(str.indexOf('/') != -1) {
					var parts = str.split('/');
    				var filename = parts[parts.length - 1];
    				return filename.split('.')[0];
				}
				else {
    				var parts = str.split('\\');
    				var filename = parts[parts.length - 1];
    				return filename.split('.')[0];
				}
    		}
    	},
    	{
    		name: 'zipFileName',
    		convert: function(val, rec) {
    			var str = rec.get('uploadedZipFilePath');
				if(str.indexOf('/') != -1)  {
					var parts = str.split('/');
    				var filename = parts[parts.length - 1];
    				return filename.split('.')[0];
				}
				else {
					var parts = str.split('\\');
    				var filename = parts[parts.length - 1];
    				return filename.split('.')[0];
				}
    		}
    	}
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_GET_BULK_ACADEMIC_DOC_GRID_DATA
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }
});