/**
 * @author sandeep.ladvikar
 * This class is use to save the different  formats of date and time with the constants, to be change according to 
 * organization setting's date and time formats
 * @author Ravi Choudahry // change formats as discussed with product Team (B A)
 */
Ext.define('Academia.utilities.DisplayFormatMap',{
	singleton: true,
	config: {
		displayFormatMap:null
	},
	constructor:function(config){
		this.initConfig(config);
		displayFormatMap = new Ext.util.HashMap();
		
		/**
		 * Add Date formats
		 */
		displayFormatMap.add('DMY_DESH',CONSTANTS.DISPLAY_DATE_FORMAT);
		displayFormatMap.add('DMY_SLASH',CONSTANTS.DMY_SLASH_DATE_FORMAT);
		displayFormatMap.add('MDY_DESH',CONSTANTS.MDY_DESH_DATE_FORMAT);
		displayFormatMap.add('MDY_SLASH',CONSTANTS.MDY_SLASH_DATE_FORMAT);
		displayFormatMap.add('DMY_DESH_MONTH',CONSTANTS.DMY_DESH_MONTH_DATE_FORMAT);
		
		/**
		 * Add Time formats
		 */
		displayFormatMap.add('HM24',CONSTANTS.TIME_FORMAT_24hrs); 
		displayFormatMap.add('HM12',CONSTANTS.TIME_FORMAT_12hrs);
		
		
		this.displayFormatMap = displayFormatMap;
	},
	
	getDisplayFormat:function(key){
		return(this.displayFormatMap.get(key));
	}
});


