/**
 * @Author Akshay.Kalbhor
 * class for maintaning a map of the feature privileges.
 */
Ext.define('Academia.utilities.accessControl.AccessControlManager',{
	
		statics: {
			academyLocationPrivileges : null,
			//TODO: Logged in user object for displaying his/her information in the header of the application.
			loggedInUserId: null,
			allocatedAcademies: null,
			allocatedLocations: null,
			allocatedAcademyLocations: null,
			
			/**
			 * method to check the featurePrivelages
			 * @param {Array} array of academyLocations Id's which have to be assessed for the
			 * highest level of permission. 
			 * @param {Array} permissionsToCheck array which contains the permissions to be checked for the particular screen.
			 * @returns {String} DELETE, in case the highest permission for all the academy locations is Delete
			 * 					 EDIT , in case the highest permission for all the academy locations is Edit
			 * 
			 */
			checkFeaturePrivelages: function(associatedAcadLocations, permissionsToCheck) {
				 academyLocationPrivileges = this.academyLocationPrivileges;
				 var accessMap = new Ext.util.HashMap();
				 /*
				  * there can be multuple associated academy locations in case of scholarship
				  * so do not remove the for each loop on associatedAcadLocations. 
				  */
				 Ext.each(associatedAcadLocations, function(acadLocation) {
					 var acadLocPrivilegesArray = null;
					 Ext.each(academyLocationPrivileges, function(academyLocationRecord) {
						if(academyLocationRecord.accessibleAcademyLocation.academyLocationId == acadLocation) {
							acadLocPrivilegesArray = academyLocationRecord.featurePrivileges;
						}
					 });
					//  =academyLocationPrivileges[acadLocation];
					 if(Ext.isDefined(permissionsToCheck)){
						 permissionsToCheck.each(function(permission) {						
							 if(Ext.Array.contains(acadLocPrivilegesArray, parseInt(permission))) {							
								 accessMap.add(permissionsToCheck.get(permission), true);
							 } 
						 });
					 }
				 });
				 return accessMap.getKeys();
			},
			
			/**
			 * method to get the Allocated AcademyLocations
			 * @param {Array} array of academyLocations Id's which have to be assessed for the
			 * highest level of permission. 
			 * @param {Array} permissionsToCheck array which contains the permissions to be checked for the particular screen.
			 * @returns {String} DELETE, in case the highest permission for all the academy locations is Delete
			 * 					 EDIT , in case the highest permission for all the academy locations is Edit
			 * 
			 */
			getAllocatedAcademyLocations: function() {
				var acadLocationArray = this.allocatedAcademyLocations;
				Ext.each(acadLocationArray, function(acadLoc) {
					acadLoc.academyLocationName = acadLoc.academyName +'-'+ acadLoc.locationName;
				});
				return acadLocationArray;
			},
			
			/**
			 * method to get the Allocated Academies			 
			 * @returns {Array} Array which contains all allocated academies to logged in user 
			 * 
			 */
			getAllocatedAcademies: function() {
				return this.allocatedAcademies;	
			},
			
			/**
			 * method to get the Allocated Locations			 
			 * @returns {Array} Array which contains all allocated locations to logged in user 
			 * 
			 */
			getAllocatedLocations: function() {
				return this.allocatedLocations;	
			},
			
			/**
			 * method to return the Academy location privileges
			 * @author akshay.kalbhor
			 */
			getAcademyLocationPrivileges: function() {
				return this.academyLocationPrivileges;
			}
		},
		
		/**
		 * method to return the logged in userID.
		 * @returns {Object} the logged in user id. 
		 */
		getLoggedInUserId: function() {
			return this.loggedInUserId;
		},
		
		/**
		 * method to return all the academies that are accessible to the logged in user.
		 * @returns {Object} academyLocations collection of type ???
		 * use Academia.utilities.accessControl.AccessControlManager.getAccessibleAcademies() 
		 */
		getAccessibleAcademies: function() {			 
			return this.getAllocatedAcademies();
		},
		
		/**
		 * method to return all the locations that are accessible to the logged in user.
		 * @returns {Object} academyLocations collection of type ??? 
		 */
		getAccessibleLocations: function() {
			return this.getAllocatedLocations();
		},
		
		
});