/**
 */
Ext.define('Academia.utilities.ux.CustomCheckboxField', {
    extend : 'Ext.form.field.Checkbox',
	alias : 'widget.customcheckboxfield', 
	
	/**
     * @cfg {Boolean} [allowBlank=true]
     * Specify false to validate that the value's length must be > 0. If `true`, then a blank value is **always** taken to be valid regardless of any {@link #vtype}
     * validation that may be applied.
     *
     * If {@link #vtype} validation must still be applied to blank values, configure {@link #validateBlank} as `true`;
     */
    allowBlank : true,

    /**
     * @cfg {String} blankText
     * The error text to display if the **{@link #allowBlank}** validation fails
     */
    blankText : 'This field is required',

    getErrors : function(value) {
        var me     = this,
            errors = me.callParent([value]);

        if (!me.checked && !me.allowBlank) {
            errors.push(me.blankText);
        }

        return errors;
    }
});
