/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.DMSView.DmsTaskGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.dmstaskgrid',
	store:'DMSStore.DMSTaskStore',
	title: getCommonTranslation('ACTIVE'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [/*{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getDMSTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},*/{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getDMSTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	}/*,{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	}*/],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns:[
		{
			header : getDMSTranslation('MESSAGE'),
			dataIndex : 'workflowInstance_message',
			flex:1
		},{
			header : getDMSTranslation('DUE'),
			dataIndex : 'workflowInstance_dueDate',
			flex:0.5,
			renderer: function(date) {
				if(!isNullOrEmpty(date)) {
					return dateRender(date);
				}
			}
		},{
			header : getDMSTranslation('STARTED'),
			dataIndex : 'workflowInstance_startDate',
			flex:0.5,
			renderer: function(date) {
				if(!isNullOrEmpty(date)) {
					return dateRender(date);
				}
			}
		},{
			header : getDMSTranslation('STATUS'),
			dataIndex : 'propertyLabels_bpm_status',
			flex:1
		},{
			header : getDMSTranslation('TYPE'),
			dataIndex : 'title',
			flex:0.5
		},{
			header : getDMSTranslation('DESCRIPTION'),
			dataIndex : 'description',
			flex:1
		},{
			header : getDMSTranslation('STARTED_BY'),
			dataIndex : 'workflowInstance_initiator_firstName',
			flex:0.5
		}
	]
});
