/**
 * Amit G
 */
Ext.define('Academia.view.admission.admissionActivityReport.SourceWiseCountOfEnquiries', {
	extend: 'Ext.window.Window',
	alias: 'widget.sourcewisecountofenquiries',
	title:getAdmissionTranslation('SOURCEWISE_ENQUIRY_COUNT'),
	modal: true,
	resizable: true,
	autoScroll: true,
	frame: true,
	width: 630,
	minHeight: 450,
	//height: 450,
	maxHeight : 370,
	padding:'10 10 10 10',
	items: [{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top'
		},
		items: [{
			xtype:'displayfield',
			name:'academyLocation',
			itemId:'academyLocation',
			style:{marginLeft:'13px'},
			fieldLabel:getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION')
		},{
			xtype: 'displayfield',
			name: 'userName',
			itemId:'userName',
			style:{marginLeft:'13px'},
			fieldLabel: getFeeAndPaymentCommonTranslation('User'),
		}]
	},{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'grid',
			autoScroll:true,
			name:'sourceWiseEnquiryGrid',
			itemId:'sourceWiseEnquiryGridItemId',
			frame:false,
			border:true,
			style:{marginLeft:'10px'
				},
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			store: 'admission.admissionActivityReport.EnquiryCountGroupBySourceTypeGridStore',
			maxHeight:300,
			hideHeaders :false,
			features: [{
				ftype: 'summary',
				showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
			}],
			columns: [{
				header: getEnquiryTranslation('SOURCE'),
				dataIndex: 'enquirySource',
				flex:.1,
				summaryRenderer: function(value, summaryData, dataIndex) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				},
				renderer:function(value){
					if(!isNullOrEmpty(value)){
						return value;
					}else{
						return 'No-Source';
					}
				}
				
			},{
				header: getAdmissionTranslation('NO_OF_LEADS'),
				dataIndex: 'count',
				flex:.1,
				summaryType: 'sum',
				align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return  value;
				}

			}]
		}]
	}]
});