/**
 * Common Grid used for Documents grid in the "Admission Setting" and the "Application Setting"
 * tabs of the Admission Cycle Setting of the Admission Module.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.ApplicationDocumentsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.applicationdocumentsgrid',
	border : true,
	cls:'panelNoSpace',
	store : 'Academia.store.admission.admissionCycle.DocumentGridRecords',
	
	columns : [{
		text : getAdmissionTranslation('APPLICABILITY_RULE'),
		dataIndex: 'applicabilityRule',
		hidden: true
	},/* {
		dataIndex : 'version',
		hidden: true
	}, {
		dataIndex : 'id',
		hidden: true
	},*/ {
		text : getAdmissionTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentType',
		sortable : true,
		flex: .4,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		text : getAdmissionTranslation('APPLICABILITY'),
		dataIndex : 'applicability',
		sortable : true,
		flex: .3,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	}, {
		text : getAdmissionTranslation('REMARKS'),
		dataIndex : 'remark',
		sortable : true,
		flex: .3
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	 emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'Academia.store.admission.admissionCycle.DocumentGridRecords'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}]
});