/**

 * @author Rajkumar.patidar
 * 
 * This component is used for to show applicant and direct submission details in form  
 */
Ext.define('Academia.view.admission.applicantFormSaleDirectSubmission.ApplicantCommonForm', {
	extend:'Academia.view.common.IdGeneratorForm',
	formCode : 'createApplication',
	alias: 'widget.applicantcommonform',
	title:getAdmissionTranslation('CREATE_APPLICATION'),
	frame:true,
	plugins: "formlabelrequired",
	border: false,
	autoScroll: true,
	cls:'horizontalScrollingFixed', 
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'hidden',
		name: 'applicationId'
	}, {
		xtype: 'hidden',
		name: 'version',
	},{
		xtype:'hidden',
		name:'applicationFormId'
	},{
		xtype:'hidden',
		name:'applicationCode'
	},{
		xtype:'hidden',
		name:'externalSysRefOne'
	},{
		xtype:'hidden',
		name:'externalSysRefTwo'
	},{
		xtype:'hidden',
		name:'externalSysRefThree'
	},{
		xtype:'hidden',
		name:'enquirerSalutationID',
		itemId:'enquirerSalutationID'
	},{
		xtype: 'fieldset',
		style:{marginTop:'-10px !important'},
		items: [{
			xtype:'panel',
			cls: 'panelNoSpace',
			style:{marginLeft:'-2px !important'},
			items:[{
				xtype: 'radiogroup',
				itemId:'applicantDetailsId',
				name:'applicantDetailsId',
				columns: 2,
				vertical: true,
				items: [
				        { boxLabel: getAdmissionTranslation('APPLICATION_FORM_SALE'), name: 'whehterDirectSubmission', inputValue: false,checked:true},
				        { boxLabel: getAdmissionTranslation('DIRECT_SUBMISSION'), name: 'whehterDirectSubmission', inputValue: true}
				        ]
			}]
		}, {
			xtype: 'fieldcontainer',
			itemId: 'searchComponent',
			//style:{marginLeft:'10px'},
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'applicationType',
				itemId: 'cmbApplicationType',
				valueField: 'name',
				displayField: 'value',
				store:Ext.create('Academia.store.admission.applicationFormSale.ApplicantTypeStore'),
				labelAlign: 'top',
				fieldLabel : getAdmissionTranslation('APPLICANT_TYPE'), //Enquiry ID		
				editable: false,
				queryMode: 'local',
				value: 'FRESH_APPLICANT', // getAdmissionTranslation('FRESH_APPLICANT'),
				allowBlank: false
			},{
				fieldLabel: getAdmissionTranslation('APP_ENQ_STD_ID'), // Application/Enquiry/Student ID
				xtype: 'textfield',
				readOnly:true,
				name: 'code',            
				//labelWidth: 'auto',
				hidden:true,                  
				itemId: 'dispalyCode'
			},{
				fieldLabel: getAdmissionTranslation('STUDENT_ID'),
				xtype: 'textfield',
				readOnly:true,
				name: 'linkStudentCode',            
				hidden:true,                  
				itemId: 'linkStudentCode'
			}, {
				xtype: 'hidden',
				name: 'linkStudentId',
				itemId: 'linkStudentId'
			}, {
				xtype: 'hidden',
				name: 'applicantId',
				itemId: 'applicantId'
			},{
				xtype: 'hidden',
				name: 'saleRefPrimaryId',
				itemId: 'saleRefPrimaryId'
			}, {
				xtype: 'hidden',
				name: 'saleRefId',
				itemId: 'saleRefId'
			}, {
				xtype: 'hidden',
				name: 'saleRefType',
				itemId: 'saleRefType'
			}]
		}]
	},{
		xtype: 'panel',        
		style:{marginTop:'-10px !important'},
		itemId:'FormNoPanelItemId',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype:'hidden',
			name:'personId'
		},{
			xtype:'hidden',
			name:'personVersion'
		},{
			xtype: 'fieldcontainer',        
			width: 236,
			itemId:'fieldcontainerformNoManuallyId',
			items:[{
				xtype: 'radiogroup',
				style:{marginLeft:'-2px !important'},
				itemId:'formNoManuallyId',
				labelAlign: 'top',
				fieldLabel:getAdmissionTranslation('ASSIGN_MANUALLY_FORM_NO'),
				columns: 2,
				vertical: true,
				items: [
				        { boxLabel: getAdmissionTranslation('YES'), name: 'isFormNoManually', inputValue: true},
				        { boxLabel: getAdmissionTranslation('NO'), name: 'isFormNoManually', inputValue: false,checked:true}
				        ]
			},{
				xtype: 'textfield',
				itemId: 'formNoId',
				fieldLabel: getAdmissionTranslation('FORM_NO'),
				name: 'token',
				hidden:true,
				emptyText: getCommonTranslation('ID_AUTOGENERATE')
			}]
		}]
	},{
		xtype: 'fieldset',
		itemId : 'personalDetailFieldset',
		style:{marginTop:'30px !important'},
		title: getAdmissionTranslation('PERSONAL_DETAILS'), // Personal Details
		items: [{
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			width: 'auto',
			style:{marginTop:'-10px !important'},
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('SALUTATION'),
				name: 'salutation',
				itemId: 'salutation',
				store: 'common.SalutationStore',
				valueField: 'id',
				displayField: 'salutationName',
				//queryMode: 'local',
				allowBlank: false,
				editable: false
			}, {
				xtype: 'textfield',
				name: 'firstName',
				itemId: 'firstName',
				fieldLabel: getAdmissionTranslation('APPLICANT_FIRST_NAME'), //First Name
				allowBlank: false,
				maxLength:100,
				enforceMaxLength :true,
				//vtype: 'spaceAndFrenchSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				name: 'middleName',
				itemId: 'middleName',
				fieldLabel: getAdmissionTranslation('APPLICANT_MIDDLE_NAME'),
				maxLength:53,//Middle Name
				enforceMaxLength :true,
				//vtype: 'spaceAndFrenchSpecialCharactersAsInput'
			}]
		}, { 
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				name: 'lastName',
				itemId: 'lastName',
				fieldLabel: getAdmissionTranslation('APPLICANT_LAST_NAME'), //Last Name       
				//vtype: 'spaceAndFrenchSpecialCharactersAsInput',
				maxLength:100,
				enforceMaxLength :true,
				allowBlank: false	
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('APPLICANT_SHORT_NAME'),
				name: 'shortName',
				itemId: 'shortName',
				allowBlank: false,
				//vtype: 'spaceAndFrenchSpecialCharactersAsInput'
			}, {
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_PRINT_NAME'),
				name: 'printName',
				itemId: 'printName',
				allowBlank: false,
				//vtype: 'spaceAndFrenchSpecialCharactersAsInput'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
				name: 'firstNameOtherLanguage',
				itemId:'firstNameOtherLanguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}, {
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLanguageId',
				maxLength : 53,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLanguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME_OTHER_LANGUAGE'),
				name: 'shortNameOtherLanguage',
				itemId: 'shortNameOtherLanguageId',
				maxLength : 100,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME_OTHER_LANGUAGE'),
				minLength: 3,
				name: 'printNameOtherLanguage',
				itemId: 'printNameOtherLanguageId',
			}]
		},{ 
			xtype: 'fieldcontainer',
			margin: '0px',
			items: [
			{
				xtype:'panel',
				cls: 'MarginSpaceForScroller',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items:[{
					xtype: 'datefield',
					name: 'birthDate',
					itemId: 'birthDate',
					fieldLabel: getAdmissionTranslation('DOB'), //Birth Date
					editable: true,
					maxValue: new Date(),
					//--submitFormat: CONSTANTS.DATE_FORMAT,
//					format: CONSTANTS.DATE_FORMAT,
					allowBlank: false,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}, {
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('GENDER'), //Gender
					name: 'genderCSM',
					itemId: 'gender',
					valueField: 'id',
					displayField: 'value',
					store: 'Academia.store.common.GenderTypeStore',
					//queryMode: 'local',
					editable: false,
					allowBlank: false
				},{
					xtype: 'multiselectcombofield',
					name: 'applicantModeOfEnquiry',
					itemId:'applicantModeOfEnquiryItemId',
					fieldLabel: getEnquiryTranslation('MODE_OF_ENQUIRY'),
					store:'enquiry.EnquiryModeStore',
					cls:'commonAutoHeightMultiselectField',
					valueField: 'id',
					forceSelection:true,
					displayField: 'value'
				}]
			}]
		}]
	},{
		xtype: 'fieldset',
		itemId : 'contactFieldSet',
		defaults: {
			labelAlign: 'top'
		},
		style: {
			marginTop: '30px !important'
		},
		title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
		items: [{
			html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required" style="color:red"> *</span>',
			margin: 0,
			width:700
		},{
			xtype: 'fieldcontainer',
			fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
			itemId : 'addressPhoneNoContainerId',
			//allowBlank:false,
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'customcombobox',
				hiddenName : 'phoneNumber1',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:'common.CountryStore',
				//queryMode: 'local',
				triggerAction : 'all',
				name : 'phoneCountryCode',
				itemId : 'phoneCountryCode',
				//editable : false,
				forceSelection: true,
				minChars: 1,			
				width: 70
			}, {
				xtype : 'numberfield',
				name : 'phoneAreaCode',
				itemId : 'phoneAreaCode',
				width: 108,
				maxLength: 5,
				enforceMaxLength : true,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false
			}, {
				xtype : 'numberfield',
				itemId : 'phoneNoField',
				name : 'phoneNo',
				itemId : 'phoneNo',
				maxLength: 10,
				enforceMaxLength : true,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
				hideTrigger: true,
				width: 226,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false
			} ]
		}, {
			xtype: 'fieldcontainer',
			fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			itemId : 'addressMobileNoContainerId',
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'customcombobox',
				name : 'mobileCountryCode',
				itemId : 'cellCountryCode',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:'common.CountryStore',
				//queryMode: 'local',
				triggerAction : 'all',
				//editable : false,
				forceSelection: true,
				minChars: 1,
				width:  70
			}, {
				xtype : 'numberfield',
				name : 'mobileNumber',
				itemId : 'mobileNumber',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength : true,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				width : 226
			}]
		},{
			xtype: 'fieldcontainer',
			labelAlign: 'top',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [ {
				xtype: 'textfield',
				fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
				name: 'emailId',
				itemId: 'emailId',
				vtype: 'myemail',
				maxLength: '100',
				allowBlank: false
			},{
				xtype: 'datefield',
				name: 'submissionDate',
				itemId: 'applicationDate',
				fieldLabel: getAdmissionTranslation('APPLICATION_DATE'), //Submission Date
				//editable: false,
//				value : new Date(),
				//--submitFormat: CONSTANTS.DATE_FORMAT,
//				format: CONSTANTS.DATE_FORMAT,
				listeners: {
          		  render: function(obj) {
          			  obj = dateFormatRender(obj);
          			setTimeout(function() {
          			  obj.setValue(new Date());
          			}, 1000);
          		  }
          	  }
			},{
				 xtype: 'customcombobox',
				 name: 'applicationOwner',
				 store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
				 fieldLabel: getCommonTranslation('APPLICATION_OWNER'),
				 valueField: 'id',
				 displayField: 'value',
				 itemId:'applicationOwner',
				 queryParam:'name',
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: '',
				 forceSelection:true,
				 allowBlank:false,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
				 }
			 }]
		}]
	},{
		xtype: 'fieldset',
		title: getAdmissionTranslation('RELATIONSHIP_DETAILS'),
		style: {marginTop: '30px !important'},
		itemId:'relationshipDetailsId',
		items:[{
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'fieldcontainer',        
				width: 'auto',
				layout: 'hbox',
				style: {
					marginTop: '-10px !important'
				},
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
					name: 'relationship',
					valueField: 'name',
					displayField: 'value',
					itemId: 'relationShipField',
					store: 'common.CreateApplicationRelationshipStore',
					editable: false,
					allowBlank: true
				},{
					xtype: 'textfield',
					name: 'relationshipUserExternal',
					itemId:'relationshipUserExternal',
					//readOnly:true,
					fieldLabel: getAdmissionTranslation('EMPLOYEE_ID'), //Last Name       
					allowBlank: true
				},{
					xtype: 'checkboxfield',
					itemId: 'relationshipCheckbox',
					labelAlign: 'right',
					//width: 446,
					width: 300,
					boxLabel: getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'),
					name: 'relationshipCheckbox',
					inputValue: true,
					uncheckedValue: false,
					style:{marginTop:'23px'}
				},{
					xtype: 'customcombobox',
					name: 'relationshipStudent',
					itemId: 'relationshipStudent',
					fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
					store: 'admission.manageForm.StudentWithOutAL',
					//style:{marginLeft:'52px !important'},
					valueField: 'id',
					hidden:true,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'relationshipUser',
					itemId: 'relationshipUser',
					//fieldLabel: getAdmissionTranslation('EMPLOYEE_ID'),
					fieldLabel: getAdmissionTranslation('USER_ID'),
					store: 'criteriabuilder.userquicksearch.QuickSearchCode',
					valueField: 'id',
					displayField: 'value',
					queryParam:'code',
					//style:{marginLeft:'32px !important'},
					minChars:3,
					typeAhead:false,
					hidden:true,
		            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		            enableKeyEvents  : 'true',
		            hideTrigger:false,
		            //cls:'gridInputCustomStyle',
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            triggerAction: '',
		            forceSelection:true,
					  listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                        '{value}' +
			                    '</div>';
			                }
			            }
				},{
					xtype:'hidden',
					name:'personRelationshipsId'
				},{
					xtype:'hidden',
					name:'personRelationshipsVersion'
				}]
			},{
				xtype: 'fieldcontainer',        
				width: 'auto',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'textfield',
					name: 'relationshipName',
					itemId:'relationshipName',
					readOnly:true,
					fieldLabel: getAdmissionTranslation('NAME_SURNAME'), //Last Name       
					allowBlank: true
				}, {
					xtype: 'fieldcontainer',
					fieldLabel: getAdmissionTranslation('MOBILE_NO'),
					itemId : 'relationshipMobileCountryFieldContainerId',
					layout : {
						type : 'hbox'
					},
					items : [{
						xtype : 'customcombobox',
						name : 'relationshipMobileCountryCode',
						itemId : 'relationshipMobileCountryCodeItemId',
						valueField : 'isdCode',
						displayField : 'isdCode',
						store:'common.CountryStore',
						triggerAction : 'all',
						readOnly:true,
						editable : false,
						width:  70,
						listeners:{
							change : function(obj,value){
								var form = obj.up();
								countryCodeField = form.down('#relationshipMobileCountryCodeItemId');
								mobileField = form.down('#relationshipMobileNo');
								countryCodeField.getStore().load({
				        			callback: function(records, operation, success) {
				        				if (success) {
				        						var countryCode = value;
				            					for(var i in records){
				            						if(records[i].data.isdCode == countryCode){
				        								countryInfo = records[i].data;
				        								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : 0;
				        								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : 11;
				        								if(!isNullOrEmpty(mobileField.getValue())) {
				        									mobileField.isValid();
				        									try{
				        				        				form.getForm().checkValidity();
				        				        	 		}
				        				        	 		catch(e){}
				        								}
				        								break;
				        							}
				            					}
				        				}
				        			}
				        		});
								}
						}
					}, {
						xtype : 'numberfield',
						name: 'relationshipMobileNo',
						itemId: 'relationshipMobileNo',
						hideTrigger: true,
						mouseWheelEnabled:false,
						maxLength: 15,
						minLength: 0,
						enforceMaxLength : true,
						readOnly:true,
						minValue:0,
						allowExponential:false,
						keyNavEnabled: false,
						width:  146
						//fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
					}]
				}, {
					xtype: 'textfield',
					name: 'relationshipEmail',
					vtype:'myemail',
					itemId: 'relationshipEmail',
					readOnly:true,
					fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
				},{
					xtype:'hidden',
					name:'relatedPersonId'
				},{
					xtype:'hidden',
					name:'relatedPersonVersion'
				},{
					xtype: 'button',
					itemId: 'btnAddRelationshipDetails',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					style:{marginTop:'30px'},
					tooltip: getCommonTranslation('ADD')
				}]
			}]
		}]
	},{
		xtype: 'fieldset',
		title: getAdmissionTranslation('HOSTEL_DETAILS'),
		style: {marginTop: '30px !important'},
		itemId:'hostelRequiredDetailsItemId',
		name: 'hostelRequiredDetails',
		items:[{
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
			       xtype: 'fieldcontainer',
			       width: 'auto',
			       defaults: {
			           labelAlign: 'top',
			           width: 226
			       },
			       layout: 'hbox',
			   items: [{
				   	xtype: 'checkboxfield',
				   	name: 'whetherHostelApplicable',
				   	//boxLabel: getProgramandcourseTranslation('WHETHER_BOARDING_SCHOOL'),
				   	boxLabel: getAdmissionTranslation('WHETHER_HOSTEL_REQUIRED'),
				   	itemId:'whetherHostelApplicable',
				   	inputValue : true,
				   	uncheckedValue: false,
				   	style: {
				   		//marginTop: '25px'
				   	}
			   	}]
			    }, {
			       xtype: 'fieldcontainer',
			       itemId: 'hostelFieldsContainer1',
			       width: 'auto',
			       defaults: {
			           labelAlign: 'top',
			           width: 226
			       },
			       layout: 'hbox',
			       items: [{
			           xtype: 'textfield',
			           name: 'dietaryRequirements',
			           itemId: 'dietaryRequirementsItemId',
			           fieldLabel: getAdmissionTranslation('WHETHER_DIETARY_REQUIREMENTS'),
			           labelSeparator : '',
			           maxLength: 255
			       }, {
			           xtype: 'textfield',
			           name: 'foodAllergies',
			           itemId: 'foodAllergiesItemId',
			           fieldLabel: getAdmissionTranslation('WHETHER_FOOD_ALLERGIC'),
			           labelSeparator : '',
			           maxLength: 255
			       }, {
			           xtype: 'textfield',
			           name: 'sleepingDisorder',
			           itemId: 'sleepingDisorderItemId',
			           fieldLabel: getAdmissionTranslation('WHETHER_SLEEPING_DISORDER'),
			           labelSeparator : '',
			           maxLength: 255
			       }]
			   }, {
			       xtype: 'fieldcontainer',
			       itemId: 'hostelFieldsContainer2',
			       width: 'auto',
			       defaults: {
			           labelAlign: 'top',
			           width: 226
			       },
			       layout: 'hbox',
			       items: [{
			           xtype: 'textfield',
			           name: 'anyMedicalNeedsOrSomething',
			           itemId: 'anyMedicalNeedsOrSomethingItemId',
			           fieldLabel: getAdmissionTranslation('WHETHER_MED_EMO_PHYSICAL_NEED'),
			           labelSeparator : '',
			           maxLength: 255
			       }]
			   }]
		}]
	},{
		xtype:'addprogramgrid'
	},{
		xtype:'fieldcontainer',
		//layout:'hbox',
		//width:'auto',
		items: [{
			xtype: 'button',
			text: getAdmissionTranslation('SUBMIT_AND_GENERATE_FORM_NO'),
			formBind: true,
			itemId: 'SubmitAndGenerateFormNoBtn',
			ui: 'CustomBtnSubmit',
			style:{marginLeft:'12px',marginTop:'-10px'},
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			style:{marginTop:'-10px'},
			scale: CONSTANTS.BUTTONSIZE   
		}]
	}]
});
