/*
 * @author prathamesh.sheth
 * 
 * This is the basic structure of applicant relative module.
 */
Ext.define('Academia.view.admission.applicationFormSale.ApplicantRelatives', {
    extend: 'Ext.tab.Panel',
    xtype: 'plain-tabs',
    alias: 'widget.applicantrelatives',
   /* requires : ['Academia.view.personinfo.common.personalinfo.ParentGuardianGrid', 'Academia.view.personinfo.common.personalinfo.SiblingDetailsGrid' ], */
    plain: true,
    autoScroll: false,
    applicationId: '',
    personId : null,
    cls: 'horizontal-scrolling-fix', 
    /*style: {
        overflow: 'hidden !important',
        margin: '0!important'
    },  */   
    defaults: {
        autoscroll: false,
        margin: 0 
    },
    bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,		
    items: [{
        title: getAdmissionTranslation('PROGRAM_PREFERENCES'), //Program Preferences
        itemId:'programPreferences',
        closable: false,        
        disabled: true,
        items: [{
            title: getAdmissionTranslation('PROGRAM_DETAILS'), //Program Details
            xtype: 'addprogramtabgrid',
            itemId: 'addprogramtabgrid',
            applicationProgramType:'APPLICATION_FORM_SALE_APPLICATION_PROGRAMS'
        }]
    }, {
        title: getAdmissionTranslation('PARENT_DETAILS'), // Parent Details
        itemId:'parentDetails',
        closable: false,
        disabled: true,
        items: [{
            xtype: 'parentguardiangrid',
            itemId : 'applicantionParentGuardianGrid'
        }]
    }, {
        title: getAdmissionTranslation('SIBLING_DETAILS'), //Sibling Details
        itemId:'siblingDetails',
        closable: false,
        disabled: true,
        items: [{
            xtype: 'siblingdetailsgrid',
            itemId : 'applicantionSiblingDetailsGrid'
        }]
    }],
    setApplicationId: function(applicationId) {
        this.applicationId = applicationId;
    },
    getApplicationId: function() {
        return this.applicationId;
    },
    setPersonId: function(personId) {
        this.personId = personId;
    },
    getPersonId: function() {
        return this.personId;
    }
});