/**
 * @author Rajkumar.Patidar
 * 
 * This component is used for to show change program details in grid
 *  
 */
var changeProgramGridStore = Ext.create('Academia.store.admission.applicationFormSale.ChangeProgramStore');
Ext.define('Academia.view.admission.applicationFormSale.ChangeProgramGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.changeprogramgrid',
    title:getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'),
    store:changeProgramGridStore,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    border: true,
    tbar: [{
    	xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
   	    header: getCommonTranslation('ACADEMY'), //Academy 
        dataIndex: 'academy.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION_NAME'), //Location
        dataIndex: 'location.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('PROGRAM'), //Program
        dataIndex: 'program.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('BATCH'), //Batch
        dataIndex: 'batch.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType.value',
        flex: .2,
        sortable: true
    }, {
        header: getCommonTranslation('MODE_OF_DELIVERY'),//Mode of Delivery
        dataIndex: 'modeOfDelivery.value',
        flex: .2,
        sortable: true
    }, {
       header: getCommonTranslation('REGISTRATION_TYPE'),//Registration Type
       dataIndex:'batchPartTime',
       flex: .2,
       sortable: true,
       renderer : function(value) {
    	   if(!isNullOrEmpty(value))
    	   {
    		   if(value==false)
    		   {
    			   return 'Full Time';
    		   }
    		   else
    		   {
    			   return 'Part Time';
    		   }

    	   }
       }}],
});
