Ext.define('Academia.view.admission.applicationFormSale.ChartDataView', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.chartdata',
    width: 600,
    height: 400,
    hidden: false,
    title: "Example working chart",
    layout: "fit",
    style: "background:#fff",
    animate: true,
    store: 'admission.applicationFormSale.ChartDataStore',
    shadow: true,
    theme: "Category1",
    legend: {
        position: "bottom"
    },
    axes: [{
        type: "Numeric",
        minimum: 0,
        position: "left",
        fields: ["value1", "value2"],
        title: "Value",
        minorTickSteps: 1,
        grid: {
            odd: {
                opacity: 1,
                fill: "#ddd",
                stroke: "#bbb",
                "stroke-width": 0.5
            }
        }
    }, {
        type: "Category",
        position: "bottom",
        fields: ["year"],
        title: "Year"
    }],
    series: [{
        type: "line",
        highlight: {
            size: 7,
            radius: 7
        },
        axis: "left",
        smooth: true,
        xField: "year",
        yField: "value1",
        title: "USA",
        markerConfig: {
            type: "cross",
            size: 4,
            radius: 4,
            "stroke-width": 0
        }
    }, {
        type: "line",
        highlight: {
            size: 7,
            radius: 7
        },
        axis: "left",
        smooth: true,
        xField: "year",
        yField: "value2",
        title: "Canada",
        markerConfig: {
            type: "circle",
            size: 4,
            radius: 4,
            "stroke-width": 0
        }
    }]
});
