/**
 * @author Prakash Sharma
 * 
 * This component is used for to student details in grid 
 */
Ext.define('Academia.view.admission.applicationFormSale.ExistingStudentDetailGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.existingstudentdetailgrid',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    store: 'admission.applicationFormSale.ExistingStudentGridStore',
    border: true,
    // autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getCommonTranslation('STUDENT_NUMBER'),
        dataIndex: 'studentCode',
        sortable: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('NATIONAL_ID'),
        dataIndex: 'nationalId',
        sortable: true,
        flex: .2
    },{
        header: getAdmissionTranslation('REVIEWED_BRAND_CAMPUS'),
        dataIndex: 'academyLocationName',
        flex: .2,
        sortable: true
    },{
        header: getAdmissionTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: .2,
        sortable: true
    },{
        header: getCommonTranslation('INTAKE'),
        dataIndex: 'batch',
        flex: .2,
        sortable: true
    },{
        header: getAdmissionTranslation('ADMISSION_ID'),
        dataIndex: 'admissionID',
        flex: .2,
        sortable: true
    },{
        header: getCommonTranslation('STUDENT_STATUS'),
        dataIndex: 'status',
        flex: .2,
        sortable: true,
        renderer: function(val) {
            var value = '';
            if (val == true) {
                value = 'Active';
            }else{
            	 value = 'Inactive';
            }
            return value;
        }
    }],
    
 /*   dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            store: 'admission.applicationFormSale.ExistingStudentGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE')           
        }]
    }],*/
   /* buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.ExistingStudentGridStore');
    }*/
});