/**
 * @author Amit G
 * 
 * This component is used for to App Owner User form  
 */
Ext.define('Academia.view.admission.applicationOwnerSetup.VWAdmAppOwnerUserIdTabForm', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.vwadmappowneruseridtabform',
	plugins: "formlabelrequired",
	items:[{
		xtype: 'panel',
		width: '100%',
		title:getCommonTranslation('USER'),
		frame:true,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			items: [{
    			xtype: 'customcombobox',
    			name: 'admAppOwnerUser',
    			itemId:'admAppOwnerUserItemId',
    			fieldLabel: getCommonTranslation('USER_CODE_NAME'),
    			store: 'admission.applicationOwnerSetup.StoAdmAppOwnerUserFindAllStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'name',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			width:456,
    			forceSelection:true,
    			allowBlank:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}/{nameToBePrinted}' +
    					'</div>';
    				}
    			}
    		
            }]
		}]
	}, {
		xtype: 'fieldcontainer',
		style:{'margin-left':'10px','margin-top':'-20px'},
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('NEXT'),
			itemId: 'admBtnNextForm',
			ui: 'CustomBtnCancel',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'admBtnUserComboResetForm',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
