/**
 *  Gajendra Verma
 */

Ext.define('Academia.view.admission.applications.applicationBase.ApplicationReviewWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.applicationreviewwindow',
	autoScroll: true,
	title:getAdmissionTranslation('REVIEW_APPLICATION'),
	modal:true,
	frame: true,
	items: [{
		xtype: 'customform',

		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:385
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'

		},{
			xtype : 'multiselectcombofield',
			name : 'reviewApplication',
			itemId:'reviewApplication',
			autoloadStore: false,
			width: 360,
			fieldLabel : getAdmissionTranslation('ASSIGN_REVIEWERS'),
			store:'common.AssignReviewersToApplicationsStore',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			border : false,
			layout : {
				type : 'hbox',
				width : '100%'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'ard_submitbuttonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {	
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'ard_cancelbuttonId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});