Ext.define('Academia.view.admission.applications.applicationBase.BasicSearch', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.basicsearch',
	autoScroll: false,
	cls:'customSearchPanel',
	itemId: 'applicationsBasicSearchForm',

	items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
		},
		items: [{
			xtype: 'radiogroup',
			itemId: 'showApplicationsMainItemId',
			name: 'showApplicationsMain',
			hidden: false,
			items: [{
				boxLabel: getAdmissionTranslation('ALL_APPLICATIONS'),
				name: 'showApplications',
				itemId : 'allApplicationItemId',
				inputValue: 'ALL_APPLICATIONS',
				checked: true
			}, {
				boxLabel: getAdmissionTranslation('MY_APPLICATIONS'),
				name: 'showApplications',
				itemId : 'myApplicationItemId',
				inputValue: 'MY_APPLICATIONS'

			}]
		}]
	},{
		xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [/*{
				xtype: 'customcombobox',
				name:'APPLICATION_ID',
				itemId:'applicationID',
//				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
				store:'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
				fieldLabel:getAdmissionTranslation('APPLICATION_NO'),
				width:226,
				valueField: 'code',
				displayField: 'code',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}'  +
		                    '</div>';
		                }
		            }
			},*/ /*{
				xtype: 'textfield',
				name: 'APPLICATION_ID',
				itemId: 'applicationID',
				//Application No.
				fieldLabel: getAdmissionTranslation('APPLICATION_NO')   //Application No.
			},*/ {
				xtype: 'customcombobox',
				name:'APPICANT_PRINT_NAME',
				itemId:'applicantName',
//				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
				store:'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
				fieldLabel:getCommonTranslation('APPICANT_ID_NAME'),
				width:226,
				valueField: 'code',
				displayField: 'printName',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}/{printName}'  +
		                    '</div>';
		                }
		            }
			},/*{
				xtype: 'textfield',
				name: 'APPLICANT_NAME',
				itemId: 'applicantName',
				//Applicant Name
				fieldLabel: getAdmissionTranslation('APPLICANT_NAME')   //Applicant Name
			},*/{
				 xtype: 'customcombobox',
				 name: 'applicationOwner',
				 store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
				 fieldLabel: getCommonTranslation('APPLICATION_OWNER'),
				 valueField: 'id',
				 displayField: 'value',
				 itemId:'applicationOwner',
				 queryParam:'name',
				 width:226,
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: '',
				 forceSelection:true,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
				 }
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		//marginLeft:'8px',
	        		marginTop:'25px'
	        	},
	        	itemId:'applicationPaymentPending',
	        	boxLabel: getCommonTranslation('APPLICATION_PAYMENT_PENDING'),
	        	name: 'applicationPaymentPending',
	        	inputValue : true
	        },{
	        	xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('APPLICATION_STATUS'), //Application Status
				name: 'APPLICATION_STATUS',
				itemId: 'applicationStatus',
				editable: false,
				//Application Status
				store: 'admission.applications.applicationBase.ApplicationStatusComboStore',                 
				valueField: 'name',
				displayField: 'value',
				value : '',
				queryMode : 'local'
	        }]
		}, { 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		//width:'100%',
		cls: 'spaceIssueForFields',
		defaults: {
			labelAlign: 'top',
			//width:226
		},
		style: {
			marginTop: '40px!important',
			//marginLeft:'-10px !important'
		},
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
		items: [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
//			translationKey : 'ACADEMY_LOCATION',
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
            //editable: false,
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width:460,
            typeAhead : false,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: 'all',
    	    //anyMatch : true,
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },/*{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY'),   //Academy
			name: 'ACADEMY',
			itemId: 'academy',
			editable: false,
			//Academy
			store: 'Academia.store.common.AcademyStore',                
			valueField: 'id',
			displayField: 'value',
			//value : 'All',
			queryMode : 'local'
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('LOCATION'), //Location
			name: 'LOCATION',
			itemId: 'location',
			editable: false,
			//Location
			store: 'Academia.store.organization.academylocations.LocationByAcademyStore',
			disabled:true,
			valueField: 'id',
			displayField: 'value',
			//value : 'All',
			queryMode : 'local'
		},*/{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('STAGE_STATUS'), //Stage Status
			name: 'STAGE_STATUS',
			itemId: 'stageStatus',
			editable: true,
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			store: 'admission.applications.applicationBase.ApplicationStageStatusComboStore',                 
			valueField: 'name',
			displayField: 'value',
			queryMode : 'local',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
			loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ADMISSION_STATUS'),   //Admission Status
			name: 'ADMISSION_STATUS',
			itemId: 'admissionStatus',
			editable: true,
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			store: 'admission.applications.applicationBase.AdmissionStatusComboStore',                 
			valueField: 'name',
			displayField: 'value',
			queryMode : 'local',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
			 loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
		},{
			xtype: 'customcombobox',
			name: 'OFFER_TYPE',
			itemId: 'offerType',
			fieldLabel: getCommonTranslation('OFFER_TYPE'),
			store: Ext.create('Academia.store.admission.applications.applicationBase.OfferTypeStore'),
			valueField: 'name',
			displayField: 'value',
			forceSelection: true
		    	
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('OFFER_STATUS'), //Program Status
			name: 'PROGRAM_STATUS',
			itemId: 'programStatus',
			editable: true,
			typeAhead : false,
			forceSelection : true,
			anyMatch : true,
			store: 'admission.applications.applicationBase.ApplicationProgramStatusComboStore',                 
			valueField: 'name',
			displayField: 'value',
			queryMode : 'local',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
			 loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
		},{
			xtype: 'customcombobox',
			name:'ESCALATION_ASSIGNEE_ID',
			store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
			itemId:'dliAdmAssignToItemId',
			fieldLabel: getCommonTranslation('OFFER_ESCALATION_ASSIGNEE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			//width:200,
			minChars:3,
			allowBlank: true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'+
					'</div>';
				}
			}
		},{
			xtype: 'datefield',
			name: 'OFFER_EXPIRY_START_DATE',
			itemId: 'offerExpiryStartDate',
			vtype: 'daterange',
			disabled:true,
			endDateField: 'offerExpiryEndDate',
			fieldLabel: getAdmissionTranslation('OFFER_EXPIRY_START_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				collapse: function(field) {
					field.picker.el.dom.style.visibility = 'hidden';
				},
				expand: function(field) {
					field.picker.el.dom.style.visibility = '';
				}
				
			}
		}, {
			xtype: 'datefield',
			name: 'OFFER_EXPIRY_END_DATE',
			itemId: 'offerExpiryEndDate',
			vtype: 'daterange',
			disabled:true,
			startDateField: 'offerExpiryStartDate',
			fieldLabel: getAdmissionTranslation('OFFER_EXPIRY_END_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				collapse: function(field) {
					field.picker.el.dom.style.visibility = 'hidden';
				},
				expand: function(field) {
					field.picker.el.dom.style.visibility = '';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SELECTION_PROCESS'), //Selection Process
			name: 'SELECTION_PROCESS',
			itemId: 'selectionProcess',
			editable: false,
			//Selection Process
			store: 'Academia.store.admission.admissionCycle.SelectionProcesses',                 
			valueField: 'id',
			displayField: 'value',
			//value : 'All',
			queryMode : 'local'
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SELECTION_PROCESS_STAGE'), //Selection  Process Stage
			name: 'SELECTION_PROCESS_STAGE',
			itemId: 'selectionProcessStage',
			editable: false,
			//Selection  Process Stage
			store: 'Academia.store.admission.admissionCycle.SelectionProcessStageStore',
			disabled:true,
			valueField: 'id',
			//width:170,
			displayField: 'value',
			//value : 'All',
			queryMode : 'local'
		},{
			xtype: 'multiselectcombofield',
			name: 'PROGRAM_DEPARTMENT_ID',
			itemId:'programDepartmentItemId',
			fieldLabel: getCommonTranslation('PROGRAM_DEPARTMENT'),
			store:Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			forceSelection:true,
			matchFieldWidth:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					render: function(combo){
						combo.getStore().on("load", function(store, items){
							if(Ext.select('.x-boundlist-item').elements[0]){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
	    },{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('PROGRAM_GROUP'), //Program Group
//			translationKey : 'PROGRAM_GROUP',
			name: 'PROGRAM_GROUP',
			itemId: 'programGroup',
			editable: false,
			//Program Group
			store: 'Academia.store.admission.applicationFormSale.ProgramGroupComboStore',
			//disabled:true,
			valueField: 'id',
			displayField: 'value',
			//value : 'All',
			queryMode : 'local'
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
//			translationKey : 'PROGRAM',
			name: 'PROGRAM',
			itemId: 'program',
			//editable: false,
			autoload: false,
			store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			//disabled:true,
			valueField: 'id',
			displayField: 'valueCode',  
			//value : 'All',
			queryParam:'qry',
			//queryMode : 'local',
			typeAhead : false,
            forceSelection:true,
            hideTrigger:false,
            triggerAction: 'all',
    	    //anyMatch : true,
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+ 
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
			name: 'BATCH',
			itemId: 'batch',
			editable: true,
			autoload: false,
			disabled:true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
	        minChars:3,
	        typeAhead:false,
	        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        queryMode :'remote',
	        listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
			},
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
			name: 'SEAT_TYPE',
			itemId: 'seatType',
			editable: false,
			autoload: false,
			disabled : true,
			store:'common.SeatTypesByBatchId',
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local'
		},{
    		xtype: 'customcombobox',
    		itemId: 'selectionStageCombo',
    		name:'PROGRAM_SELECTION_PROCESS_STAGE_ID',
            store: 'Academia.store.admission.selectionStage.SelectionStageFromSeatType',
    		fieldLabel: getAdmissionTranslation('SELECT_STAGE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            disabled:true,
            editable: false,
            labelAlign: 'top',
            autoload: false
    	}, {
			xtype: 'textfield',
			name: 'EMAIL_ID',
			itemId: 'emailID',
			fieldLabel: getAdmissionTranslation('EMAIL_ID')  
		},{
			xtype: 'textfield',
			name: 'MOBILE_NO',
			itemId: 'mobileNo',
			fieldLabel: getAdmissionTranslation('MOBILE_NO')   
		},{
    		xtype: 'customcombobox',
    		itemId: 'priorityStatus',
    		name:'PRIORITY_STATUS',
    		fieldLabel: getCommonTranslation('PRIORITY_STATUS'),
    		store: Ext.create('Academia.store.common.RaisePriorityStore'),
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			forceSelection: true,
            editable: false,
            labelAlign: 'top'
    	}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
    		xtype: 'customcombobox',
    		itemId: 'currentActivity',
    		name:'CURRENT_ACTIVITY',
    		fieldLabel: getCommonTranslation('CURRENT_ACTIVITY'),
    		store: Ext.create('Academia.store.enquiry.CurrentActivityStore'),
			valueField: 'id',
			displayField: 'value',
			queryMode: 'remote',
			forceSelection: true,
            editable: false,
            labelAlign: 'top'
    	},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('COUNTRY'), //Program Group
			name: 'COUNTRY_ID',
			autoload: false,
			itemId: 'countryCombo',
			store: 'common.CountryStore',
			valueField: 'id',
			displayField: 'countryName',
			//queryMode : 'local',
			queryParam:'countryName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
			
		},{
			xtype: 'textfield',
			name: 'ALTERNATE_EMAIL_ID',
			itemId: 'alternateMobileNo',
			fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO')  
		},{
			xtype: 'customcombobox',
			name:'ENQUIRY_NO',
			itemId:'enquiryNo',
//			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
			store:'enquiry.EnquiryCodeSearchByApplicationMadeForEnqStore',
			fieldLabel:getCommonTranslation('TRACK_ENQUIRY_NO'),
			//width:226,
			valueField: 'code',
			displayField: 'code',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			forceSelection: true,
            editable: true,
            typeAhead:false,
            cls:'commonAutoHeightMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            minChars:3,
            anyMatch:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'textfield',
			name: 'NATIONAL_ID',
			itemId: 'nationalId',
			fieldLabel: getCommonTranslation('IDENTITY_NUMBER')  
		},{
			xtype: 'datefield',
			name: 'START_DATE',
			itemId: 'START_DATE',
			vtype: 'daterange',
			endDateField: 'END_DATE',
			fieldLabel: getAdmissionTranslation('START_DATE'),
//			allowBlank: false,
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				collapse: function(field) {
					field.picker.el.dom.style.visibility = 'hidden';
				},
				expand: function(field) {
					field.picker.el.dom.style.visibility = '';
				}
			}
		}, {
			xtype: 'datefield',
			name: 'END_DATE',
			itemId: 'END_DATE',
			vtype: 'daterange',
			startDateField: 'START_DATE',
			fieldLabel: getAdmissionTranslation('END_DATE'),
//			allowBlank: false,
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				collapse: function(field) {
					field.picker.el.dom.style.visibility = 'hidden';
				},
				expand: function(field) {
					field.picker.el.dom.style.visibility = '';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'applicantDocumentStatus',
			itemId:'applicantDocumentStatusItemId',
			fieldLabel: getCommonTranslation('DOCUMENT_STATUS'),
			store:'common.DocumentStatusCSMAllStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'query',
			minChars:3,
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(Ext.select('.x-boundlist-item').elements[0]){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
		},{
			xtype: 'customcombobox',
			name: 'ADMISSION_COMMITMENT_FEE_STATUS',
			itemId: 'admissionCommitmentFeeStatus',
			fieldLabel: getCommonTranslation('ADMISSION_COMMITMENT_FEE_STATUS'),
			store: 'admission.applications.applicationBase.AdmissionCommitFeeStatusStore',                 
			valueField: 'name',
			displayField: 'value',
			forceSelection: true,
			editable: false
		}]},{

			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
			xtype: 'customcombobox',
			name:'ADMISSION_COMMITMENT_FEE_APPLICABLE',
			itemId: 'admissionCommitmentFeeApplicable',
			fieldLabel: getCommonTranslation('ADMISSION_COMMITMENT_FEE_APPLICABLE'), 
			valueField: 'id',
			displayField: 'value',
			store: {
				fields: ['text', 'value', 'code'],
				data : [
				        {"id":"true", "value":"Yes", "code": "Yes"},
				        {"id":"false", "value":"No", "code": "No"}
				        ]
			},
			editable: false
		},{
				xtype: 'customcombobox',
				name:'STAGE_FEE_STATUS',
				itemId: 'stageFeeStatus',
				fieldLabel: getAdmissionTranslation('STAGE_FEE_STATUS'), 
				valueField: 'id',
				displayField: 'value',
				store: {
					fields: ['text', 'value', 'code'],
					data : [
					        {"id":"SETTLED", "value":"Paid", "code": "Paid"},
					        {"id":"NOT_SETTLED", "value":"Unpaid", "code": "Unpaid"}
					        ]
				},
				editable: false
			}, {
				xtype: 'customcombobox',
				name:'STAGE_FEE_APPLICABLE',
				itemId: 'stagefeestatuscombo',
				fieldLabel: getAdmissionTranslation('STAGE_FEE_APPLICABLE'), 
				valueField: 'id',
				displayField: 'value',
				store: {
					fields: ['text', 'value', 'code'],
					data : [
					        {"id":"true", "value":"Yes", "code": "Yes"},
					        {"id":"false", "value":"No", "code": "No"}
					        ]
				},
				editable: false
			},{
				xtype: 'multiselectcombofield',
				name: 'applicantModeOfEnquiry',
				itemId:'applicantModeOfEnquiryItemId',
				fieldLabel: getEnquiryTranslation('MODE_OF_ENQUIRY'),
				store:'enquiry.EnquiryModeStore',
				valueField: 'id',
				displayField: 'value',
				queryParam:'query',
				minChars:3,
				typeAhead:true,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			},{
				xtype: 'datefield',
				name: 'SUBMISSION_START_DATE',
				itemId: 'SUBMISSION_START_DATE',
				vtype: 'daterange',
				//disabled:true,
				endDateField: 'SUBMISSION_END_DATE',
				fieldLabel: getAdmissionTranslation('SUBMISSION_START_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					collapse: function(field) {
						field.picker.el.dom.style.visibility = 'hidden';
					},
					expand: function(field) {
						field.picker.el.dom.style.visibility = '';
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'SUBMISSION_END_DATE',
				itemId: 'SUBMISSION_END_DATE',
				vtype: 'daterange',
				//disabled:true,
				startDateField: 'SUBMISSION_START_DATE',
				fieldLabel: getAdmissionTranslation('SUBMISSION_END_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					},
					collapse: function(field) {
						field.picker.el.dom.style.visibility = 'hidden';
					},
					expand: function(field) {
						field.picker.el.dom.style.visibility = '';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'MODE_OF_DELIVERY_ID',
				itemId: 'modeDeliveryId',
				fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
				store: 'common.ModeOfDeliveryStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				editable: true,
				queryMode: 'local',
				anyMatch:true,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
 					listeners: {
 						beforeshow: function(picker) {
 							picker.minWidth = picker.up('combobox').getSize().width;
 						}
 					},
 					loadingText: getCommonTranslation('SEARCHING'),
 					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 					getInnerTpl: function() {
 						return '<div class="search-item">' +
 						'{value}'  +
 						'</div>';
 					}
 				}
			},{
				xtype: 'customcombobox',
				name: 'REGISTRATION_TYPE',
				itemId: 'registrationTypeId',
				fieldLabel: getCommonTranslation('REGISTRATION_TYPE'),
				store: 'campaignnew.RegistrationTypeStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				editable: true,
				queryMode: 'local',
				anyMatch:true,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
 					listeners: {
 						beforeshow: function(picker) {
 							picker.minWidth = picker.up('combobox').getSize().width;
 						}
 					},
 					loadingText: getCommonTranslation('SEARCHING'),
 					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 					getInnerTpl: function() {
 						return '<div class="search-item">' +
 						'{value}'  +
 						'</div>';
 					}
 				}
			},{
				xtype: 'customcombobox',
				name: 'PRE_ELIGIBILITY',
				itemId: 'preEligibilty',
				fieldLabel: getCommonTranslation('PRE_ELIGIBILITY'),
				store: Ext.create('Academia.store.admission.applications.applicationBase.PreEligibilityType'),
				valueField: 'id',
				displayField: 'value',
				queryMode: 'remote',
				forceSelection: true,
				hidden:true
			
			},{
	    		xtype: 'customcombobox',
	    		itemId: 'offTrackApplicationStatus',
	    		name:'OFF_TRACK_APPLICATION_STATUS',
	    		fieldLabel: getCommonTranslation('OFF_TRACK_APPLICATION_STATUS'),
	    		valueField: 'id',
				displayField: 'value',
				store: {
					fields: ['text', 'value', 'code'],
					data : [
						{"id":"true", "value":getCommonTranslation('LOST'), "code": "Lost"},
				        {"id":"false", "value":getCommonTranslation('REAPPLIED'), "code": "Reapplied"}
					]
				},
				editable: false
	    	}
			]  
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'FINAL_APPROVER',
				itemId: 'finalApproverId',
				fieldLabel: getCommonTranslation('FINAL_APPROVER'),
				store: Ext.create('Academia.store.admission.applications.applicationBase.FinalApprovalStore'),
				valueField: 'name',
				displayField: 'value',
				forceSelection: true
			},{
	    		xtype: 'customcombobox',
	    		itemId: 'pendingOfferflag',
	    		name:'PENDING_OFFER_FLAG',
	    		fieldLabel: getCommonTranslation('PENDING_OFFER_FLAG'),
	    		store: Ext.create('Academia.store.common.PendingOfferLetterCSMStore'),
				valueField: 'id',
				displayField: 'value',
				queryMode: 'remote',
				forceSelection: true,
	            editable: false,
	            labelAlign: 'top',
	            matchFieldWidth:true
	    	},{
				xtype: 'customcombobox',
				name: 'POPIA_STATUS',
				itemId: 'popiastatusId',
				fieldLabel: getCommonTranslation('POPIA_STATUS'),
				store:'enquiry.PopiaStatusStore',
				displayField:'value',
				valueField:'name',
				value : '',
				editable: false,
				queryMode : 'local'
				
			},{
	    		xtype: 'customcombobox',
	    		itemId: 'priority',
	    		name:'PROGRAM_PRIORITY',
	    		fieldLabel: getCommonTranslation('PROGRAM_PRIORITY'),
	    		store: Ext.create('Academia.store.common.ProgramPriorityStore'),
				valueField: 'name',
				displayField: 'value',
				queryMode: 'remote',
				forceSelection: true,
	            editable: false,
	            labelAlign: 'top'
	    	}
			]  
		}],
		
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		style : {
			marginTop : '20px',
			marginLeft : '-2px'
		},
		items: [{
			xtype: 'button',
			text: getAdmissionTranslation('SEARCH'), 
			itemId: 'applicationsListBasicSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CLEAR_SEARCH'),
			itemId: 'ClearSearchBtn',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
		
	}]  
});