/**
 * @author Kamini Birla
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.ImportBulkAdmissionApprovalDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.importbulkadmissionapprovaldownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		itemId:'programBatchContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			itemId:'academyLocationProgramContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
	            xtype: 'customcombobox',
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            name: 'ACAD_LOC_ID',
	            itemId:'academyLocationCombo',
	            editable: true,
	            store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            width:410,
	            matchFieldWidth:true,
	            allowBlank:false,
	            minChars:3,
	            typeAhead:true,
	            forceSelection :true,
	            queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
			}]
		}]
	},{
					xtype:'fieldcontainer',
					layout : 'hbox',
					items:[{
						xtype: 'fieldcontainer',
						width: 'auto',
					items: [{
			           	 xtype: 'button',
			        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
			             itemId: 'downoladBtnId',
			             hidden:false,
			             ui: 'CustomBtnSubmit'
			        },{
		                xtype: 'button',
		                text: getCourseTxCommonTranslation('RESET'),
		                itemId: 'resetBtn',
		                buttonAlign: 'left',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }]
	}]
	}]
});
