/**
 * @author Trupti.Paoneker
 * 
 * This component is used for to show References  in grid details.
 * 
 */
Ext.define('Academia.view.admission.applications.applicationDetailsAndReferences.ReferenceGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.referencegrid',    
    title: getAdmissionTranslation('REFERENCES'), //References    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {    	     
    	var grid=this;
    	var store=Ext.create('Academia.store.admission.applications.applicationDetailsAndReferences.ReferenceGridStore');
    	Ext.apply(this, {
            store: store        
        });
        this.callParent(arguments);
        var custompagingtoolbar=grid.down('custompagingtoolbar');
        if(custompagingtoolbar){
        	custompagingtoolbar.bindStore(store);        	
        }
    },
    columns: [{
        header: getAdmissionTranslation('FULL_NAME'), //References Name
        dataIndex: 'referenceName',        
        flex: .2
    }, {
        header: getAdmissionTranslation('COUNTRY_CODE'),
        dataIndex: 'mobileCountryCode',
        sortable: false,
        flex: .2,
        hidden:true
    }, {
        header: getAdmissionTranslation('CONTACT_NO'), //Contact no.
        dataIndex: 'contactNo',
        sortable: false,
        flex: .2
    }, {
        header: getAdmissionTranslation('EMAIL'),
        dataIndex: 'emailId',
        flex: .2
    }, {
        header: getAdmissionTranslation('AFFILIATION'),
        dataIndex: 'affiliation',
        hidden: true,
        flex: .2
    }, {
        header: getAdmissionTranslation('DESIGNATION'), //Designation
        dataIndex: 'designation',        
        flex: .2
    }, {
        header: getAdmissionTranslation('REMARK'),
        dataIndex: 'remark',
        flex: .2
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add References
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit References
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View References
        iconCls: 'view-icon'
    },{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),//Delete department
		glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
	},{
		xtype: 'button',
	    itemId: 'btnResendLink',
	    text:  getAdmissionTranslation('RESEND_LINK'), //Add Program
	    tooltip: getAdmissionTranslation('RESEND_LINK'), //Add Program       
	    scale: CONSTANTS.BUTTONSIZE,
	    hasDisableForProfileViewMode:true        
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }]
});