/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Pre-Admission Refunds in grid.
 *   
 */
Ext.define('Academia.view.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissionRefundsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.preadmissionrefundsgrid',    
    title: getAdmissionTranslation('PRE_ADMISSION_REFUNDS'), //Pre-Admission Refunds	    
    border: true, 
    plugins:[{
    	 ptype: 'rowexpander',
	     pluginId:'preAdmissionRefundRowExpander',
	     rowBodyTpl:new Ext.XTemplate('<table style="border:1px solid black;">', 
	        '<tr>',
	        		'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEE_HEAD') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('ADJUSTED_AMOUNT') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('FEE_AMOUNT') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('PAYMENT_VOUCHER') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('PAYMENT_DATE') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('VOUCHER_MODE') + '</th>',
        			'<th style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getAdmissionTranslation('ADJUSTED_BILL_NUMBER') + '</th>',
     		'</tr>',
     		'<tpl for="applicationPaymentRefundFeeHeadDetailsModels">',
     		'<tr>',
	     		'<td style="width:100px;text-align:center">{feeHeadName}</td>',
				'<td style="width:100px;text-align:center">{adjustedAmount}</td>', 
				'<td style="width:100px;text-align:center">{amount}</td>', 
				'<td style="width:100px;text-align:center">{paymentVoucherNo}</td>', 
				'<td style="width:100px;text-align:center">{paymentDate}</td>', 
				'<td style="width:100px;text-align:center">{voucherMode}</td>',
				'<td style="width:100px;text-align:center">{adjustedBillNo}</td>',
     		'</tr>', 
     		'</tpl>', 
	        '</table>')
    }],
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },        
    initComponent: function() { 
    	var grid=this;    	
     	var store=Ext.create('Academia.store.admission.applications.preAdmissionPaymentsRefundsAndFeePlans.PreAdmissiontRefundGridStore');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);
         var custompagingtoolbar=grid.down('custompagingtoolbar');
         if(custompagingtoolbar){
         	custompagingtoolbar.bindStore(store);        	
         }
         
    },        
    columns: [{
        header: getAdmissionTranslation('ACADEMY'), //Academy
        dataIndex: 'academyName',
        flex: .2
    }, {
        header: getAdmissionTranslation('LOCATION'), //Location
        dataIndex: 'locationName',
        flex: .2
    }, {
        header: getAdmissionTranslation('PROGRAM'), //Program
        dataIndex: 'programName',
        flex: .2      
    }, {
        header: getAdmissionTranslation('BATCH'), //Batch
        dataIndex: 'batchName',
        flex: .2
    }, {
        header: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
        dataIndex: 'seatType',
        flex: .2
    }, {
        header: getAdmissionTranslation('FEE_PLAN'), //Fee Plan
        dataIndex: 'feePlanName',
        flex: .2   
    }, {
        header: getAdmissionTranslation('AMOUNT_REFUNDED'), //Amount Refunded
        dataIndex: 'amountRefunded',
        renderer: Ext.util.Format.numberRenderer('0.00'),
        flex: .2     
    }],    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') 
        }]
    }]    
});
