/**
 *  @author Rajkumar.patidar
 */

var manageFormGridStore = Ext.create('Academia.store.admission.manageForm.FeeAdmissionList');
Ext.define('Academia.view.admission.manageForm.ManageFormList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageformlist',
	store : manageFormGridStore,
	title: getAdmissionTranslation('LIST_OF_FORMS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType: 'checkboxmodel',
	isGridConfigurable : true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : manageFormGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'collectPayment',
		text : getAdmissionTranslation('COLLECT_PAYMENT'),
		disabled : false,
		tooltip: getAdmissionTranslation('COLLECT_PAYMENT')
	},{
		xtype: 'button',
		itemId: 'assignApplicationID',
		tooltip: getAdmissionTranslation('ASSIGN_APPLICATION_ID'),
		disabled : false,
		text : getAdmissionTranslation('ASSIGN_APPLICATION_ID')
	},{
		xtype: 'button',
		itemId: 'submitForm',
		disabled : false,
		text : getAdmissionTranslation('SUBMIT_FORM'),
		tooltip: getAdmissionTranslation('SUBMIT_FORM')
	},{
		xtype: 'button',
		itemId: 'sendReminder',
		disabled : false,
		text : getEnquiryTranslation('SEND_REMINDER'),
		tooltip: getEnquiryTranslation('SEND_REMINDER')
	}],
	columns: [{
		header : getCommonTranslation('FORM_NO'),
		dataIndex : 'token',
		flex:1
	},{
		header : getCommonTranslation('APPLICATION_CODE'),
		dataIndex : 'applicationCode',
		flex:1,
		renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">'+value+'</a>';
			} else {
				return  value;
			}
		}
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'applicantName',
		flex:1
	},{
		header : getCommonTranslation('FEES'),
		dataIndex : 'totalFee',
		flex:1
	},{
		header : getCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex:1
	},{
		header : getCommonTranslation('FEE_TYPE'),
		dataIndex : 'feeStage',
		flex:1
	},{
		header : getCommonTranslation('EXISTING_STUDENT_NUMBER'),
		dataIndex : 'existingStudentNumber',
		flex:1,
		renderer : function(value) {
			if (!isNullOrEmpty(value)){
				return value;
			}else {
				return '-';
			}
		}

	},{
		header : getCommonTranslation('APPLICANT_TYPE'),
		dataIndex : 'applicantType',
		flex:1,
		renderer : function(value) {
			if (!isNullOrEmpty(value)) {
				if (value == 'EXISTING_STUDENT') {
					return 'Existing Student Application';
				}else {
					return 'New Student Application';
				}
			}
			else{
				return 'New Student Application';
			}
		}

	},{
		header : getCommonTranslation('FORM_RECEIPT_NO'),
		dataIndex : 'receiptNo',
		flex:1
	},{
		header : getCommonTranslation('BRAND_CAMPUS'),
		dataIndex : 'academyLocationName',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programNameToBePrint',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatName',
		hidden:true,
		flex:1
	},
	{
		header : getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex : 'modeofDelivery',
		hidden : true,
		flex : 1
	}, {
		header : getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex : 'registrationType',
		hidden : true,
		flex : 1,
		sortable : true,
		renderer : function(value) {
			if (!isNullOrEmpty(value)) {
				if (value == false) {
					return 'Full Time';
				} else {
					return 'Part Time';
				}

			}
		}
	},{
		header : getCommonTranslation('CONTACT_NO'),
		dataIndex : 'mobileNumber',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('APPLICATION_IDENTIFIER'),
		dataIndex : 'applicationIdentifier',
		hidden:true,
		flex:1,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	}]
});