/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of fee heads for refund.  
 */
Ext.define('Academia.view.admission.preAdmissionFeesAndRefund.FeeHeadRefundGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.feeheadrefundgrid',
    store: 'Academia.store.admission.preAdmissionFeesAndRefund.ApplicationFeeDetailsStore',
    title: getAdmissionTranslation('FEE_HEADS_FOR_REFUND'), //Fee Heads For Refunds	    
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*
     * required for cell editing plugin
     * selType: selection type -> cellModel ie: only a single cell from the row to be selected.
     */
    selType: 'cellmodel',
    plugins: [
        Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1
        })
    ],
    columns: [{
        header: getAdmissionTranslation('RECEIPT_NO'), //Receipt No
        dataIndex: 'receiptNumber',
        flex: .2
    }, {
        header: getAdmissionTranslation('FEE_HEAD'), //Fee Head
        dataIndex: 'feeHead',
        flex: .2
    }, {
        header: getAdmissionTranslation('FEE_AMOUNT'), //Fee Amount
        dataIndex: 'feeAmount',
        flex: .2
    }, {
        header: getAdmissionTranslation('REFUNDED_AMOUNT'), //Refunded Amount
        dataIndex: 'refundedAmount',
        flex: .2
    }, {
        header: getAdmissionTranslation('STATUS'), //Status
        dataIndex: 'refundStatus',
        flex: .2,
        renderer:function(value){
    		 if(value){
				    return  getAdmissionTranslation('REFUNDABLE');
	     		 }else{
					    return  getAdmissionTranslation('NOT_REFUNDABLE');
		     		 }
			}
    }, {
        header: getAdmissionTranslation('AMOUNT_TO_REFUND'), //Amount to Refund
        dataIndex: 'amountToRefund',
        flex: .2,
        editor: {
			 xtype: 'numberfield',
			 allowBlank: false,
			 editable: true,
			 minValue:0
		}
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
            store: 'Academia.store.admission.preAdmissionFeesAndRefund.ApplicationFeeDetailsStore'
        }]
    }],
    tbar : [{		
		xtype : 'button',				
		itemId : 'processRefund',
		text : getAdmissionTranslation('PROCESS_REFUND')
	}]
});
