/**
 * @author Pravin.Surve
 */
Ext.define('Academia.view.admission.replacement.ApproveReplacementGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.approvereplacementgrid',
    title: getAdmissionTranslation('REPLACEMENT_LIST'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
    	xtype:'displayfield',
    	fieldLabel: getAdmissionTranslation('REPLACED_STUDENT'),
    	labelWidth: 500
    },{
    	xtype:'displayfield',
    	fieldLabel: getAdmissionTranslation('REPLACED_BY'),
    	labelWidth: 200
    }],
    columns: [{
        header: getAdmissionTranslation('REPLACE_TO_APPLICATION_ID'),
        dataIndex: 'replacedToBeAppId',
        sortable: true,
        flex: 0.5,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedToBeAppName',
        sortable: true,
        flex: 1
    }, {
        header: getAdmissionTranslation('CURRENT_STATUS'),
        dataIndex: 'replacedToBeStageStatus',
        sortable: true,
        flex: 1
    },{
        header: getAdmissionTranslation('REPLACE_BY_APPLICATION_ID'),
        dataIndex: 'replacedByAppId',
        sortable: true,
        flex: 0.5,
        renderer: function(value) {
            return '<a href="#">' + value + '</a>';
        }
    }, {
        header: getAdmissionTranslation('STUDENT_NAME'),
        dataIndex: 'replacedByAppName',
        sortable: true,
        flex: 1
    }, {
        header: getAdmissionTranslation('CURRENT_STATUS'),
        dataIndex: 'replacedByStageStatus',
        sortable: true,
        flex: 1
    },{
        header: getAdmissionTranslation('STATUS'),
        dataIndex: 'replacementStatus',
        sortable: true,
        flex: 1
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.replacement.ApproveReplacementListStore');
    }

});