/**
 * This panel is used in the basic setting of the selection process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.BasicSettingsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.basicsettingsform',
    title: getAdmissionTranslation('BASIC_SETTINGS'),
    itemId: 'basicSettingsForm',
    collapsible: true,
//    cls:'panelNoSpace',
    frame: true,
    plugins: "formlabelrequired",

    defaults: {
        labelAlign: 'top'
    },
    items: [{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'fieldcontainer',
            flex: .3,
            layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: '500px'
            },
            items: [{
            	xtype: 'hidden',
            	name: 'id'
            },{
            	xtype: 'hidden',
            	itemId: 'selectionProcessStageIdField',
            	name: 'selectionProcessStageId'
            },{
            	xtype: 'hidden',
            	itemId: 'versionField',
            	name: 'version'
            },{
            	xtype: 'hidden',
            	itemId: 'gradeTypeName',
            	name: 'gradeTypeName'
            },{
                xtype: 'customcombobox',
                itemId: 'evaluationCombo',
                name: 'evaluationType',
                fieldLabel: getAdmissionTranslation('BASIS_OF_EVALUATION'),
                width: 226,
                store: 'Academia.store.common.BasisOfEvaluations',
                displayField: 'value',
                valueField: 'id',
                value: 'MARKS',
                editable:false
                
            },{
				xtype: 'customcombobox',
				style: {
	        		paddingTop: '7px'
	        	},
				name: 'gradeTypeId',			
				fieldLabel:getExaminationTranslation('GRADE_TYPE'),
				store:'gradeMaster.GradeTypeMappingStore',
				width:226,
        		labelAlign:'top',
				itemId:'gradeTypeId',
				displayField:'value',
				valueField:'id',
				editable:false,
				allowBlank: false,
				hidden:true
			},{
                xtype: 'radiogroup',
                style: {
            		paddingTop: '7px'
            	},
                fieldLabel: getAdmissionTranslation('SELECTION_MODE'),
                columns: 2,
                width: 226,
                vertical: true,
                items: [{
                    boxLabel: getAdmissionTranslation('AUTOMATIC'),
                    name: 'whetherAutomatic',
                    checked : true,
                    inputValue: true
                }, {
                    boxLabel: getAdmissionTranslation('MANUAL'),
                    name: 'whetherAutomatic',
                    inputValue: false
                }]
            }, {
                html: ""
            }, {
                xtype: 'textfield',
                itemId: 'droolsRulesComponent',
                name: 'ruleForGradeToMark',
                fieldLabel: getAdmissionTranslation('RULES_FOR_CONVERTING'),
                width: 226,
                hidden: true
          
            }, {
                xtype: 'textarea',
                width: 226,
                name: 'remark',
                fieldLabel: getAdmissionTranslation('REMARKS')
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'previousStagesConsideredComponent',
            flex: 1.1,
            layout: {
                type: 'vbox'
            },
            /*defaults: {
            	//width: 226
            },*/
            items: [{
            	xtype: 'component',
            	style: {
            		paddingTop: '7px'
            	},
            	 xtype: 'hidden',
                 itemId: 'previousStageText',
                 name: 'previousStageText',
                 fieldLabel: getAdmissionTranslation('PREVIOUS_STAGES_CONSIDERED'),
            	 //html: getAdmissionTranslation('PREVIOUS_STAGES_CONSIDERED')
            }, {
                xtype: 'checkbox',
                itemId: 'previousStagesCheck',
                name: 'includePrevsStagePerformance',
                labelWidth: 226,
                boxLabelAlign: 'after',
                inputValue: true,
                fieldLabel: getAdmissionTranslation('INCLUDE_PREVIOUS_STAGES')
            }, {
            	xtype:"fieldcontainer",
            	itemId: 'previousStageWeightageComponent',
            	hidden: true,
            	//FIXME: [AKR] remove the items array after checking the functionality.
            	items: []
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'saveBasicSettings',
            text: getCommonTranslation('SAVE'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }]
});