/**
 * This Grid is used for Conditional Marks Grid of the evaluation parameters 
 * tab of the stage configuration tab of the Selection Process.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionProcess.ConditionalMarksGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.conditionalmarksgrid',
	title : getAdmissionTranslation('CONDITIONAL_MARKS'),
	collapsible: true,
	border : true,
	store: 'Academia.store.admission.selectionProcess.ConditionalMarks',
	
	columns : [ {
		text : getExaminationTranslation('RULE_NAME'),
		dataIndex: 'ruleName',
		sortable : true,
		flex : .4
	}, {
		text : getAdmissionTranslation('MARKS'),
		dataIndex: 'marks',
		sortable : true,
		flex : .2
	}, {
		text : getAdmissionTranslation('RULE_DESCRIPTION'),
		dataIndex : 'ruleDescription',
		sortable : true,
		flex : .4
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	 emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'Academia.store.admission.selectionProcess.ConditionalMarks'
        }]
    }],
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}]
});