Ext.define('Academia.view.admission.selectionStage.CloseStagePopupWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.closestagepopupwindow',
    title: getAdmissionTranslation('PROGRAM_SELECTION_STAGE_STATUS'),
    autoScroll: true,
    maxHeight: 600,
    modal: true,

    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        items: [{
            xtype: 'livesearchcombo',
            itemId:'approvedBy',
            name: 'approvedBy',
            fieldLabel: getCommonTranslation('APPROVER')
        }, {
            xtype: 'datefield',
            name: 'approvedDate',
            itemId:'approvedDate',
//            value : new Date(),
//            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            fieldLabel: getCommonTranslation('APPROVED_DATE'),
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
        }, {
            xtype: 'textareafield',
            name: 'remark',
            fieldLabel: getCommonTranslation('CLOSURE_REASON')
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls : 'windowBtnPos',
    		style :{marginLeft: '-1px',marginTop:'10px'},
    		
            items: [{
            	xtype: 'button',
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            },{
            	xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});
