/**
 * This Grid is used for Stage Statistics Grid of the Selection Stage.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.selectionStage.StageStatasticsGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias : 'widget.stagestatasticsgrid',
	title : getAdmissionTranslation('STAGE_STATASTICS'),
	border : true,
	columns : [/*{
		hidden: true,
		dataIndex: 'quotaTypeId'
	},*/{
		text : getAdmissionTranslation('QUOTA'),
		dataIndex: 'quota',
		flex: 1,
		sortable : false
	},  {
		text : getAdmissionTranslation('MIN_SEAT'),
		dataIndex: 'overriddenMinSeat',
		flex: 1,
		sortable : true,
		renderer: function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('minSeat');
			return value;
			}
	}, {
		text : getAdmissionTranslation('MAX_SEAT'),
		dataIndex : 'overriddenMaxSeat',
		flex: 1,
		sortable : true,
		renderer: function(value, metaData , record ) {
			if(isNullOrEmpty(value))
				value=record.get('maxSeat');
			return value;
		}
	},  {
		text : getAdmissionTranslation('TOTAL_STUDENTS'),
		dataIndex: 'numberOfApplication',
		flex: 1,
		sortable : true
	}, {
		text : getCommonTranslation('SELECTED'),
		dataIndex : 'numberOfSelectedStudents',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('QUOTA_VIOLATION'),
		dataIndex : 'violation',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('WAITLIST'),
		dataIndex : 'numberOfStudentsInWaitList',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('REJECTED'),
		dataIndex : 'numberOfStudentsRejected',
		flex: 1,
		sortable : true
	}, {
		text : getCommonTranslation('WITHDRAWN'),
		dataIndex : 'numberOfStudentsWithdrawn',
		flex: 1,
		sortable : true
	}, {
		text : getAdmissionTranslation('REPLACED'),
		dataIndex : 'numberOfStudentsReplaced',
		flex: 1,
		sortable : true
	}],
	tbar : [{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'multiselectcombofield2',
			autoloadStore:false,
			itemId: 'quotaTypesCombo',
        	fieldLabel: getAdmissionTranslation('QUOTA_TYPES'), 
        	store: 'Academia.store.admission.admissionCycle.QuotaTypePickList',
            displayField: 'quotaType',
            valueField: 'id',
            queryMode: 'local',
    		typeAhead: false,
    		width: '500px',
    		//height: '30px',
    		//inputHeight: '30px',
//            allowBlank: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.admissionCycle.QuotaTypePickList');
                    combo.bindStore(store);
                }
            }
		}]
	}/*, '->' , {
		xtype: 'button',
		itemId: 'transferSeatBtn',
		tooltip : getAdmissionTranslation('TRANSFER_SEATS'),
		text: getAdmissionTranslation('TRANSFER_SEATS')
	},{
		xtype: 'button',
		itemId: 'overrideQuotaLimits11',
		tooltip : getAdmissionTranslation('OVERRIDE_QUOTA_LIMITS'),
		text: getAdmissionTranslation('OVERRIDE_QUOTA_LIMITS')
	}*/],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.selectionStage.StageStatistics');
    }
});