/**
 * @author Harshit Satya
 */
Ext.define('Academia.view.admission.selectionStage.UploadSelectionStatusForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.uploadselectionstatusform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	//cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'selectionstatusUploadOptionRadioGroupItemId',
	},{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleNameDSSF',
		store:'importutility.ModuleName',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
		readOnly:true
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 480,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileFieldDSSF',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'programBatchUploadDSSF',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtnDSSF',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
