/**
 * Alumni Professional Details form
 * Author Niklesh
 */
Ext.define('Academia.view.alumniSystem.alumniList.AlumniProfessionalDetailForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alumniprofessionaldetailform',
    title: getAlumni('PROFESSIONAL_DETAILS'),
    closable: true,
    //marginLeft: '15',
    bodyPadding:'10 10 10 11',
    plugins:"formlabelrequired",
    cls: 'alumniprofessionaldetailform panelNoSpace',
    layout: {
        type: 'vbox'
    },
	autoScroll:true,
    items: [
    	{
    		xtype: 'fieldcontainer',    		
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},
    		items: [{
    			xtype:'hidden',
    			itemId:'alumniPersonItemId',
    			name: 'alumniPerson'    			
    		},{
    			xtype: 'customcombobox',
    			itemId : 'occupationIteamId',
    			fieldLabel: getAlumni('OCCUPATION'),                
    			name: 'occupation',
                store: 'alumni.alumniList.AlumniOccupationStore',
                displayField: 'value',
                valueField: 'id',
                typeAhead: true,
                editable:false,
    		},{
    			xtype: 'textfield',
    			itemId : 'organizationItemId',
    			fieldLabel: getAlumni('ORGANIZATION'),                
    			name: 'organization',
    			maxLength:100,
    		},
    		{
    			xtype: 'textfield',
    			itemId : 'designationItemId',
    			fieldLabel: getAlumni('DESIGNATION'),                
    			name: 'designation',
    			maxLength:100,
    		}
    		]
    	},
    		{
    			xtype: 'fieldcontainer',
    			layout: {
    				type : 'hbox'
    			},
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			items: [{
        			xtype: 'textfield',
        			itemId : 'emailItemId',
        			fieldLabel: getAlumni('OFFICIAL_EMAIL_ID'),                
        			name: 'email',	
        			vtype:'multiemail',
        			maxLength:100,
        		},
        		{
				xtype: 'fieldcontainer',
				itemId : 'mobileNoFldItemId',
				fieldLabel: getAlumni('OFFICIAL_CONTACT_NUMBER'),
				layout : {
					type : 'hbox'
				},
//				 width: 320,
				items : [ {
					xtype : 'customcombobox',
					name : 'phoneCountryCode',
					itemId : 'phoneCountryCode',
					valueField : 'isdCode',
					displayField : 'isdCode',
					store:'common.CountryStore',
					triggerAction : 'all',
					//editable : false,
					forceSelection:true,
					width: 65,
					minChars: 1,
					listeners:{
						change : function(obj,value){
						var form = obj.up();
						countryCodeField = form.down('#phoneCountryCode');
						mobileField = form.down('#contactNoItemId');
						countryCodeField.getStore().load({
		        			callback: function(records, operation, success) {
		        				if (success) {
		        						var countryCode = value;
		            					for(var i in records){
		            						if(records[i].data.isdCode == countryCode){
		        								countryInfo = records[i].data;
		        								mobileField.maxLength = (!isNullOrEmpty(countryInfo.maximumDigit)) ? parseInt(countryInfo.maximumDigit) : 0;
		        								mobileField.minLength = (!isNullOrEmpty(countryInfo.minimumDigit)) ? parseInt(countryInfo.minimumDigit) : 10;
		        								if(!isNullOrEmpty(mobileField.getValue())) {
		        									mobileField.isValid();
		        									try{
		        				        				form.getForm().checkValidity();
		        				        	 		}
		        				        	 		catch(e){}
		        								}
		        								break;
		        							}
		            					}
		        				}
		        			}
		        		});
						}
					}
				}, {
					xtype : 'numberfield',
					name : 'contactNo',
					itemId : 'contactNoItemId',
					minLength: 0,
					maxLength: 10,
					enforceMaxLength : true,
					// To Remove spinner buttons, and arrow key and mouse wheel listeners
					hideTrigger: true,
					keyNavEnabled: false,
					//allowBlank: false,
					mouseWheelEnabled: false,
					allowExponential:false,
					width : 150
				}]
        		},
    			{
    				xtype: 'textfield',
    				fieldLabel: getAlumni('OFFICIAL_WEBSITE'),
    				name: 'website',
    				itemId:'websiteItemId', 
    				vtype: 'websiteUrlVType',
    				maxLength:100,
    			}]
    		},{

    			xtype: 'fieldcontainer',
    			layout: {
    				type : 'hbox'
    			},
    			defaults: {
    				width: 226,
    				labelAlign: 'top'
    			},
    			items: [{
    				xtype: 'textfield',
    				fieldLabel: getAlumni('LINKEDIN'),
    				name: 'linkedIn',
    				itemId:'linkedInItemId',
    				vtype: 'linkedInUrlVType',
    				maxLength:100,
    			},{
    				xtype: 'textfield',
    				fieldLabel: getAlumni('X'),
    				name: 'twitter',
    				itemId: 'twitterItemId',	
    				vtype:'twitterUrlVType',
    				maxLength:100,
    			},{
    				xtype: 'textarea',
    				fieldLabel: getAlumni('ABOUT'),
    				name: 'about',
    				itemId: 'aboutItemId',
    				maxLength:700,
    			}]
    			},{
    				 items: [{
    			        	xtype:'fieldcontainer',
    			        	width:'100%',
//    			        	style:{
//    			        		marginLeft: '0px'
//    			        	},
    			        	layout: {
    			    			type : 'hbox'
    			    		},
    			            items: [{
    			                xtype: 'button',
    			                text: getCommonTranslation('SAVE'),
    			                itemId: 'submitButtonId',
    			                //buttonAlign: 'right',
    			                ui: 'CustomBtnSubmit',
    			                scale: CONSTANTS.BUTTONSIZE,
    			                formBind : true
    			            }, 
//    			            {
//    			                xtype: 'button',
//    			                text: getAlumni('RESET'),
//    			                ui: 'CustomBtnCancel',
//    			                itemId: 'cancelButtonId',
//    			                scale: CONSTANTS.BUTTONSIZE
//    			            }
    			            ]
    			        }]
    			}
    ],
    getAddressTemplateData: function() {
        return this.addressTemplateData;
    },
    setAddressTemplateData: function(addressTemplateData) {
        this.addressTemplateData = addressTemplateData;
    },
    getAddressPersonId: function() {
        return this.addressPersonId;
    },
    setAddressPersonId: function(addressPersonId) {
        this.addressPersonId = addressPersonId;
    }
});