/**
 * This view is used for guideline document form
 * @author Amandeep Bhatia
 */
Ext.define('Academia.view.applicantportalsetup.GuidelineDocumentForm', {
	extend : 'Ext.form.Panel',
	alias : 'widget.guidelinedocumentform',
	autoScroll : false,
	plugins: "formlabelrequired",
	defaults : {
		labelAlign:'top',
		width: 226
	},
	items : [{
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'textfield',
		fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
		itemId : 'documentNameField',
		name : 'name',
		maxLength: 50,
		allowBlank: false,
		vtype : 'NospaceAsInput'
	}, {
		xtype : 'filefield',
		ui : 'CustomBtnSubmit',
		fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
		buttonText : getPersonModuleTranslation('UPLOAD'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE,
			handler : function(){
				if(Ext.isDefined(this.up('window'))){
					this.up('window').close();	
				}
			}

		} ]
	} ]
});
