/**
 * @author bhanu ps
 */
Ext.define('Academia.view.applicationreport.ApplicationReportFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.applicationreportfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    plugins:"formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            name: 'academyLocation',
            itemId:'academyLocation',
            store:Ext.create('Academia.store.user.UserAcademyLocationStore'),
            displayField: 'value',
            valueField: 'id',
            width:460,
            allowBlank:false,
        	typeAhead:true,
        	forceSelection:true,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },{
        	xtype : 'customcombobox',
        	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
        	name : 'intakeYear',
        	itemId : 'intakeYear',
        	displayField:'value',
        	valueField:'id',
        	allowBlank:false,
//      	width:226,
        	typeAhead:true,
        	forceSelection:true,
        	minChars:3,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code}'  +
        			'</div>';
        		}
        	},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.IntakeYearStore');
        			combo.bindStore(store)
        		}
        	}
        }]
},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
    			xtype: 'customcombobox',
    			name:'applicantNameOrId',
    			itemId:'applicantNameOrId',
    			store:Ext.create('Academia.store.admission.applications.applicantProfileBase.ApplicantSmartSearchStore'),
    			fieldLabel:getAdmissionTranslation('APPLICANT_ID_OR_NAME'),
    			width:460,
    			valueField: 'code',
    			displayField: 'printName',
    			queryParam:'codeOrName',
    			minChars:3,
    			typeAhead:false,
    			hideTrigger:false,
    			triggerAction: 'all',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{code}/{printName}'  +
    	                    '</div>';
    	                }
    	            }
    		},{
    			xtype: 'customcombobox',
    			name: 'programGroup',
    			itemId:'programGroupItemId',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    			store:Ext.create('Academia.store.common.MappedProgramGroupByAL'),
    			displayField:'value',
    			valueField:'id',
    			forceSelection:true,
    			queryMode: 'remote',
    			minChars:3,
    			queryParam:'programGrpName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
     				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
     				loadingText: getCommonTranslation('SEARCHING'),
     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
     				getInnerTpl: function() {
     					return '<div class="search-item">' +
     					'{value}' +
     					'</div>';
     				}
     			}
    		}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('PROGRAM'),
			name: 'program',
			itemId: 'programItemId',
			autoload: false,
			store: 'common.ProgramsByAcademyIdLocationId',
			valueField: 'id',
			displayField: 'value',
			queryMode : 'remote',
			typeAhead: true,
            forceSelection: true,
            triggerAction: 'all',
            minChars:3,
            queryParam:'qry',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{value}' +
 					'</div>';
 				}
 			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('BATCH'),
			name: 'batch',
			itemId: 'batchItemId',
			editable: false,
			autoload: false,
			store: 'common.BatchesByProgramId',
			disabled:true,
			valueField: 'id',
			displayField: 'value',
			queryMode : 'local'
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId: 'seatTypeId',
			editable: false,
			autoload: false,
			store:'common.SeatTypesByBatchId',
			disabled:true,
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local'
		}]
		},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'startDate',
			itemId: 'startDate',
			vtype: 'daterange',
			endDateField: 'endDate',
			fieldLabel: getAdmissionTranslation('START_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype: 'datefield',
			name: 'endDate',
			itemId: 'endDate',
			vtype: 'daterange',
			startDateField: 'startDate',
			fieldLabel: getAdmissionTranslation('END_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//			format: CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
		}, {
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
}]
});
