/**
 * @author <a href="mailto:vinay.kumrawat@serosoft.in">Vinay Kumrawat</a>
 *
 */
Ext.define('Academia.view.assessmentGroup.AssessmentGroupAutoExamForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.assessmentgroupautoexamform',
	autoScroll:false,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [ 
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 420
		},
		layout : {
			type : 'vbox'
		},
		items : [
			{
				xtype:'displayfield',
				value: '<p style="font-weight: bold;">For which assessment scheme do you want to Auto Exam Schedule</p>',
	        	
			},
			{
				xtype: 'multiselectcombofield',
		        name: 'scheme',
		        itemId: 'scheme',
		        fieldLabel:getCommonTranslation('EVALUATION_PLAN'),
		        width: 420,
		        store:Ext.create('Academia.store.examinationcenters.evaluation.EvaluationPlanNo'),
		       // store:'examinationcenters.evaluation.EvaluationPlanNo',
		        queryParam: "qry",
		       // valueField : 'id',
		        //hidden:true,
		        forceSelection : true,
		        displayField : 'value',
		        hideTrigger:false,
		        typeAhead:true,
		        triggerAction: 'all',
		        minChars:3,            
		        allowBlank:false,
		        emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		        listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND')
                }
		        }]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'schemeSubmitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'schemeCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]

});