/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.attendance.StudentSearch', {   
	extend : 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.attendancestudentsearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		 xtype:'fieldcontainer',
		 width :'100%',
			labelAlign : 'top',
			layout : 'hbox',
			itemId:'attendanceTypeRadioFieldId',
			name:'attendanceTypeRadioFieldId',
			defaults: {
				labelAlign:'top'
			},
			items:[{		 
				xtype: 'radiogroup',
				itemId:'attendanceTypeRadio',
				name:'attendanceTypeRadio',
				width: '100%',
				//hidden:true,
				layout: 'hbox',
				style:{
					marginLeft:'8px'
				},
				items:[
				       { boxLabel: getCommonTranslation('PROGRAM_WISE'), name: 'attendanceTypeWise', inputValue: 'COMPLETE_DAY'},
				       { boxLabel: getCommonTranslation('COURSE_WISE'), name: 'attendanceTypeWise', inputValue: 'COURSE_LEVEL'},
				       { boxLabel: getCommonTranslation('SESSION_WISE'), name: 'attendanceTypeWise', inputValue: 'MULTIPLE_SESSION'}
				       ]
			}]	 

		}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
			name : 'attendanceAcademicTerm',
			itemId : 'attendanceAcademicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			editable:false,
			store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
		},{
			xtype: 'customcombobox',
			name:'studentName',
			itemId:'studentName_Id',
			store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
       	 xtype: 'customcombobox',
         name: 'studentStatus',
         itemId: 'studentStatusId',
         fieldLabel: getPersonModuleTranslation('STATUS'),
         value:true,
         store: Ext.create('Academia.store.common.StatusComboStore'),
         valueField: 'value',
         editable:false,
         displayField: 'name'
    }]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'hidden',
				name : 'id'
			},
			// for complete day ********************
			{
            	xtype: 'customcombobox',
    			name: 'programGroup',
    			itemId:'ProgramGroupItemId',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    			store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
    			editable: true,
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection:true,
    			editable:false
            },
			{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'programId',
				itemId : 'programBatch_programId',
				store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				displayField:'valueCode',
				valueField:'id',
				width:226,
				typeAhead:true,
				forceSelection:true,
				//allowBlank:false,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'programBatch_batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false,
				//allowBlank:false
			}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [
				//		for course Level Course Drop-Down *************
				{
					xtype : 'customcombobox',
					width:460,
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseId',
					itemId : 'courseId',
					store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
					displayField : 'courseCodeName',
					valueField : 'courseId',
					typeAhead : true,
					disable:true,
					forceSelection : true,
//					allowBlank:false,
					hidden:true,
					queryParam:'name',
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{courseCodeName}'  +
							'</div>';
						}
					}
				},{
		        	 xtype : 'customcombobox',
		        	 fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
		        	 name : 'courseVariant',
		        	 itemId : 'courseVariantId',
		        	 store: Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
		        	 displayField : 'courseVariantCode',
		        	 valueField : 'id',
		        	 typeAhead : true,
		        	 forceSelection : true,
		        	 disabled:true,
		        	 hidden:true

		         }]
		},
			// This drop down is for both condition complete day and and multiple section and
//			for program base section also  ******************* 
			{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
				        	 xtype: 'customcombobox',
				        	 name: 'periodId',
				        	 itemId:'periodIdItemId',
				        	 fieldLabel: getExaminationTranslation('PERIOD'),
				        	 store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				        	 displayField:'value',
				        	 valueField:'id',
				        	 forceSelection:true,
				        	 typeAhead:true,
				        	 disabled:true,
				        	 editable:false,
				        	//allowBlank:false
				         }, {
				        	 xtype : 'customcombobox',
				        	 fieldLabel : getCourseTxCommonTranslation('SECTION'),
				        	 width: 226,
				        	 labelAlign: 'top',
				        	 name : 'sectionId',
				        	 itemId : 'programCoursection_ID',
				        	 store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				        	 displayField : 'value',
				        	 valueField : 'id',
				        	 typeAhead : true,
				        	 disabled:true,
				        	 forceSelection : true,
				        	 editable:false
				         }, {
				        	xtype: 'customcombobox',
	        				name:'facultyName',
	        				itemId:'facultyName_Id',
	        				store: Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
	        				fieldLabel : getCommonTranslation('FACULTY_CODE'),
	        				valueField: 'id',
	        				displayField: 'value',
	        				queryParam:'name',
	        				minChars:3,
	        				typeAhead:false,
	        				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        				enableKeyEvents  : 'true',
	        				hideTrigger:false,
	        				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        				triggerAction: '',
	        				forceSelection:true,
	        				listConfig: {
	        					listeners: {
	        						beforeshow: function(picker) {
	        							picker.minWidth = picker.up('combobox').getSize().width;
	        						}
	        					},
	        					loadingText: getCommonTranslation('SEARCHING'),
	        					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        					getInnerTpl: function() {
	        						return '<div class="search-item">' +
	        						'{value}' +
	        						'</div>';
	        					}
	        				}
	        			},{
			        		 xtype : 'fieldcontainer',
			        		 itemId:'timeContainer',
			        		 hidden:true,
			        		 layout : 'hbox',
			        		 defaults : {
			        			 width : 226,
			        			 labelAlign : 'top'
			        		 },
			        		 items : [{
			        			 xtype : 'timefield',
			        			 name : 'fromTime',		
			        			 itemId : 'fromTime',			
			        			 fieldLabel:getProgramandcourseTranslation('START_TIME'),
			        			 format:'g:i A',
			        			 vtype: 'timerange',
			        			 endTimeField : 'toTime',
			        			 width:100
//			        			 allowBlank: false
			        		 },{
			        			 xtype : 'timefield',
			        			 name : 'toTime',		
			        			 itemId : 'toTime',			
			        			 fieldLabel:getProgramandcourseTranslation('END_TIME'),
			        			 format:'g:i A',
			        			 vtype: 'timerange',
			        			 startTimeField :'fromTime',
			        			 width:100
//			        			 allowBlank: false
			        		 }]
			        	 },{
				        	 xtype: 'customcombobox',
				        	 width:226,
				        	 fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				        	 name:'sessionNumber',
				        	 itemId: 'sessionNumberItemId',
				        	 displayField: 'val',
				        	 valueField: 'code',
				        	 allowBlank:true,
				        	 typeAhead:true,
				        	 forceSelection:true
				         }
				         // this is for complete day and multiple session condition ******************	
				         ]},
				         {
								xtype : 'fieldcontainer',
								width: 'auto',
								layout: 'hbox',
								defaults : {
									width : 226,
									labelAlign : 'top'
								},
								items : [{
								        	 xtype: 'customcombobox',
								        	 width:226,
								        	 fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
								        	 name:'sessionNumber1',
								        	 itemId: 'sessionNumberItemId1',
								        	 displayField: 'val',
								        	 valueField: 'code',
								        	 allowBlank:true,
								        	 typeAhead:true,
								        	 forceSelection:true
								         }
								         // this is for complete day and multiple session condition ******************	
								         ]},{
				        	 xtype : 'fieldcontainer',
				        	 width: 'auto',
				        	 layout:'hbox',
				        	 itemId:'dateContainer',
				        	 defaults : {
				        		 width : 226,
				        		 labelAlign : 'top'
				        	 },
				        	 items : [
				        	          // this Drop-Down for course level both condition course base section and program base section
				        	          /*{
		        			xtype : 'customcombobox',
		        			width: 226,
		        			labelAlign: 'top',
		        			fieldLabel : getCourseTxCommonTranslation('FACULTY'),
		        			itemId:'facutlyListId',
		        			name : 'facutlyList',
		        			store:'attendance.SectionAndFacultyByPeriodID',
//		        			store:'attendance.AttendanceFacultyList',
		        			displayField : 'facultyName',
		        			valueField : 'facultyId',
//		        			allowBlank:false,
		        			typeAhead : true,
		        			forceSelection : true,
		        			hidden:true
		        		}*/]
				         },
				         {
				        	 xtype : 'fieldcontainer',
				        	 width: 'auto',
				        	 layout : 'hbox',
				        	 defaults : {
				        		 width : 226,
				        		 labelAlign : 'top'
				        	 },
				        	 items : [{
				        		 xtype: 'customcombobox',
				        		 fieldLabel:getProgramandcourseTranslation('ATTENDANCE_STATUS'),
				        		 itemId:'facultyAttendanceStatus',
				        		 name:'facultyAttendanceStatus',
//				        		 width: 226,
//				        		 labelAlign: 'top',
				        		 store:'attendance.FacultyAttendanceStatus',
				        		 valueField : 'id',
				        		 hidden:true,
				        		 displayField : 'value'
				        	 }]
				         },{
				        	 xtype: 'customcombobox',
				        	 name: 'timeSlotList',
				        	 itemId:'timeSlotListId',
				        	 multiSelect:true,
//				        	 width: 460,
				        	 width: 226,
				        	 labelAlign: 'top',
				        	 fieldLabel: getCourseTxCommonTranslation('TIME_SLOT'),
				        	 store:'attendance.TimeSlotList',
				        	 displayField:'value',
				        	 valueField:'value',
				        	 typeAhead:true,
				        	 forceSelection:true,
				        	 //delimiter: null,
				        	 hidden:true
				         },{

				        	 xtype: 'fieldset',
				        	 collapsible : true,
				        	 collapsed: true,
				        	 title: getCommonTranslation('MORE_DETAILS'),
				        	 titleCollapse: true,
				        	 hidden:true,
				        	 itemId : 'moreDetailId',
				        	 defaults : {
				        		 labelAlign:'top',
//				        		 tdAttrs: { style: 'padding: 5px;' }
				        	 },
				        	 style: {
				        		 marginTop: '33px!important'
				        	 },
				        	 items:[{
				        		 xtype: 'fieldcontainer',
				        		 layout: 'hbox',
				        		 defaults: {
				        			 labelAlign: 'top',
				        			 width: 226
				        		 },
				        		 items: [{
				        			 xtype : 'datefield',
				        			 fieldLabel : getProgramandcourseTranslation('START_DATE'),
				        			 name : 'startDate',
				        			 itemId:'startDate',
				        			 endDateField : 'endDate',
				     				 maxValue:new Date(),
				        			 vtype : 'daterange',
				        			 listeners: {
				        				 render: function(field) {
				        					 return dateFormatRender(field);
				        				 }
				        			 }
				        		 },
				        		 {
				        			 xtype : 'datefield',
				        			 fieldLabel :getProgramandcourseTranslation('END_DATE'),
				        			 name : 'endDate',
				        			 itemId : 'endDate',
				        			 startDateField : 'startDate',
				        			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				        			 vtype : 'daterange',
				     				 maxValue:new Date(),
				        			 listeners: {
				        				 render: function(field) {
				        					 return dateFormatRender(field);
				        				 }
				        			 }
				        		 }, {
				     				xtype: 'customcombobox',
				    				name: 'studentAttendanceGroup',
				    				itemId:'studentAttendanceGroup',
				    				store:'personinfo.common.personalinfo.StudentAttendanceGroupStore',
				    				fieldLabel: getPersonModuleTranslation('STUDENT_GROUP'),
				    				valueField: 'id',
				    				displayField: 'value',
				    				editable: false,
				    	            disableKeyFilter: false,
				    				forceSelection:true,
				    				hidden:true
				    			}]
				        	 }, {
				        		 xtype: 'fieldcontainer',
				        		 layout: 'hbox',
				        		 defaults: {
				        			 labelAlign: 'top',
				        			 width: 226
				        		 },
				        		 items: [{
				        			 xtype: 'customcombobox',
				        			 fieldLabel:getProgramandcourseTranslation('ATTENDANCE_STATUS'),
				        			 itemId:'attendanceStatus',
				        			 name:'attendanceStatus',
//				        			 width: 226,
//				        			 labelAlign: 'top',
				        			 store:'attendance.StudentAttendanceStatusStore',
				        			 valueField : 'id',
				        			 displayField : 'value',
					    			 forceSelection:true
				        		 },{
				        			 xtype: 'numberfield',
				        			 itemId: 'absentForLast',
				        			 name: 'absentForLast',
				        			 fieldLabel:getProgramandcourseTranslation('ABSENT_FOR_CONSECUTIVE_DAYS'),
				        			 mouseWheelEnabled:false,
				        			 hideTrigger:true,
				        			 minValue:0,
				        			 allowDecimals:false,
				        			 enforceMaxLength : true,
				        			 maxValue : 90,
				        			 hideTrigger:true,
				        			 allowExponential:false
				        		 }]
				        	 }]
				         },{
				        	 xtype: 'fieldcontainer',
				        	 width: 'auto',

				        	 items: [{
				        		 xtype: 'button',
				        		 text: getCommonTranslation('SEARCH'),
				        		 itemId: 'searchBtn',
				        		 buttonAlign: 'left',
				        		 ui: 'CustomBtnSubmit',
				        		 formBind : true,
				        		 scale: CONSTANTS.BUTTONSIZE
				        	 },{
				        		 xtype: 'button',
				        		 text: getCourseTxCommonTranslation('RESET'),
				        		 itemId: 'resetBtn',
				        		 buttonAlign: 'left',
				        		 ui: 'CustomBtnCancel',
				        		 scale: CONSTANTS.BUTTONSIZE	        				
				        	 }]
				         }]
//}]
});