/**
 * @author Dharmendra.P
 * 
 */
Ext.define('Academia.view.attendance.attendancereport.AttendanceReportSearch', {   
	extend : 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.attendancereportsearch',  
	plugins : "formlabelrequired",
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: 'hbox',
    	defaults: {
    		width: 460,
    		labelAlign: 'top'
    	},
    	items : [{
    			xtype : 'hidden',
    			name : 'sectionType',
    			itemId: 'sectionType'
    		},{
    			xtype : 'customcombobox',
    			name : 'academyLocation',
    			itemId:'academyLocationId',
    			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
    			store:'attendance.attendancereport.AcadmyByAdmission',
    			width:226,
    			valueField : 'id',
    			displayField : 'value',
    			//allowBlank : false,
    			minChars:3,
    			typeAhead : false,
    			forceSelection:true,
    			hideTrigger:false,
    			triggerAction: 'all',
    			queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
    		},{
    			xtype : 'customcombobox',
    			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
    			name : 'academicTerm',
    			itemId : 'academicTerm',
    			displayField : 'value',
    			valueField : 'id',
    			typeAhead : true,
    			forceSelection : true,
    			store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
    			hidden : false,
    			width:226,
    			editable : false,
    			allowBlank : false
    		},{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
	     		fieldLabel : getExaminationTranslation('STUDENTID_STUDENTNAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		width:226,
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	}]
    	},{
			xtype : 'fieldcontainer',
			width: 'auto',
			defaults : {
				width : 460,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'statusCombo',
				name: 'STATUS',
				itemId:'statusComboItemId',
				width:226,
				value:true,
				editable:false
			},{
    			xtype: 'customcombobox',
    			name: 'programGroup',
    			itemId:'ProgramGroupItemId',
    			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    			store:'personinfo.common.personalinfo.AttendanceReportProgramGroupStore',
    			editable: true,
    			valueField: 'id',
    			displayField: 'value',
    			forceSelection:true,
    			width:226,
    			editable : false
    		},{
        		xtype : 'customcombobox',
        		fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        		name : 'programId',
        		itemId : 'programId',
        		store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
        		displayField:'valueCode',
        		valueField:'id',
         		width:226,
        		typeAhead:true,
        		allowBlank : false,
        		forceSelection:true,
        		minChars:3,
                queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
	     	}]
    	 },{
        	xtype : 'fieldcontainer',
        	width: 'auto',
        	layout: 'hbox',
        	defaults : {
        		width : 226,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype: 'customcombobox',
        		name: 'batchId',
        		itemId:'batchId',
        		fieldLabel : getCourseTxCommonTranslation('BATCH'),
        		disabled:true,
        		store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
        		valueField: 'id',
        		displayField: 'value',
        		typeAhead:true,
        		allowBlank : false,
        		forceSelection:true,
        		editable : false
        	},{
        		xtype: 'customcombobox',
        		name: 'periodId',
        		itemId:'periodId',
        		fieldLabel: getExaminationTranslation('PERIOD'),
        		store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
        		displayField:'value',
        		valueField:'id',
        		//allowBlank : false,
        		forceSelection:true,
        		typeAhead:true,
        		editable : false
        	},{
        		xtype : 'customcombobox',
        		fieldLabel : getCourseTxCommonTranslation('SECTION'),
        		name : 'sectionId',
        		itemId : 'sectionId',
        		store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
        		displayField : 'value',
        		valueField : 'id',
        		typeAhead : true,
        		disabled:true,
        		forceSelection : true,
        		editable : false
        	},{
        		xtype: 'customcombobox',
        		width : 226,
        		fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
        		name:'sessionNo',
        		itemId: 'sessionItemId',
        		displayField: 'val',
        		valueField: 'code',
        		hidden:true,
        		forceSelection:true,
        		queryMode:'local'
        	}]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				width : 226,
				fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				name:'sessionNo1',
				itemId: 'sessionItemId1',
				displayField: 'val',
				valueField: 'code',
			//	hidden:true,
				forceSelection:true,
				queryMode:'local'
			}]
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_DETAILS'),
			titleCollapse: true,
			hidden:true,
			itemId : 'moreDetailId',
			defaults : {
				labelAlign:'top',
			},
			style: {
				marginTop: '33px!important'
			},
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype : 'numberfield',
					name : 'attendancePercentageFrom',
					itemId : 'attendancePercentageFromId',
					fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM'),
					minValue : 0,
					maxValue:100,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					validator : function(minValue) {
						var minAbsentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageId')[0];
						var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageToId')[0];
						var maxValue = attendancePercentageToField.getValue();
						if (minValue > 0 && (maxValue > 0|| maxValue=="" || maxValue== null)) {
							minAbsentPercentageField.setDisabled(true);
							
						}else if((minValue=="" | minValue=="0" || minValue==null) && (maxValue==""|| maxValue=="0" || maxValue==null)) {
							minAbsentPercentageField.setDisabled(false);
						}
						if (maxValue!="" && maxValue != null) {
							if (minValue <= maxValue) {
								attendancePercentageToField.clearInvalid();
								return true;
							} else {
								return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM')+' should be less then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO');
							}
						} else {
							attendancePercentageToField.clearInvalid();
							return true;
						}
					}
				},{
					xtype : 'numberfield',
					name : 'attendancePercentageTo',
					itemId : 'attendancePercentageToId',
					fieldLabel : getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO'),
					minValue : 0,
					maxValue:100,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					validator : function(maxVal) {
						var minPresentPercentageField = Ext.ComponentQuery.query('numberfield#minAbsentPercentageId')[0];
						var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromId')[0];
						var minValue = attendancePercentageFromField.getValue();
						if (maxVal > 0 && (minValue > 0 || minValue=="" || minValue== null)) {
							minPresentPercentageField.setDisabled(true);
						} else if((maxVal=="" || maxVal=="0" || maxVal==null )&& (minValue==""|| minValue=="0" || minValue==null)) {
							minPresentPercentageField.setDisabled(false);
						}
						if (!isNullOrEmpty(minValue)) {
							if (maxVal >= minValue) {
								attendancePercentageFromField.clearInvalid();
								return true;
							} else {
								return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO')+' should be greater then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM');
							}
						} else {
							attendancePercentageFromField.clearInvalid();
							return true;
						}
					}
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype : 'numberfield',
					name : 'minAbsentPercentage',
					itemId : 'minAbsentPercentageId',
					fieldLabel : getCourseTxCommonTranslation('MIN_ABSENT_PERCENTAGE'),
					value : 0,
					minValue : 0,
					maxValue:100,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false,
					validator : function(val) {
						var attendancePercentageFromField = Ext.ComponentQuery.query('numberfield#attendancePercentageFromId')[0];
						var attendancePercentageToField = Ext.ComponentQuery.query('numberfield#attendancePercentageToId')[0];
						if (val > 0) {
							attendancePercentageFromField.setDisabled(true);
							attendancePercentageToField.setDisabled(true);
						} else if(val==0) {
							attendancePercentageFromField.setDisabled(false);
							attendancePercentageToField.setDisabled(false);
						}
						return true;
					}
				},{
					xtype : 'numberfield',
					name : 'absentAboveNumberOfSessions',
					itemId : 'absentAboveNumberOfSessions',
					fieldLabel : getCourseTxCommonTranslation('ABSENTS_ABOVE_NO_OF_DAYS_SESSIONS'),
					value : 0,
					minValue : 0,
					maxValue:365,
					mouseWheelEnabled :false,
					hideTrigger :true,
					allowExponential:false,
					allowDecimals:false
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCommonTranslation('START_DATE'),
					name : 'startDate',
					itemId : 'startDate',
					endDateField : 'tillDate',
					vtype : 'daterange',
					//maxValue:new Date(),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						change: function(me, newValue, oldValue, eOpts) {
    						if(!isNullOrEmpty(newValue))
    						{
	    						var date = me.parseDate(newValue);
	    						var startDate = me.up().down("#startDate");
	    						var end = me.up().down("#tillDate");
	    						var newDate = date.setMonth(date.getMonth()+6);
		                    	newDate = new Date(newDate);
		                    	end.setMaxValue(newDate);
		                    	startDate.isValid();
    						}
    					}
					}
				},{
					xtype : 'datefield',
					anchor : '100%',
					fieldLabel : getCommonTranslation('END_DATE'),
					name : 'tillDate',
					itemId : 'tillDate',
					startDateField : 'startDate',
					vtype : 'daterange',
					//maxValue:new Date(),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						change: function(me, newValue, oldValue, eOpts) {
    						if(!isNullOrEmpty(newValue))
    						{
	    						var date = me.parseDate(newValue);
	    						var startDate = me.up().down("#startDate");
	    						var endDate = me.up().down("#tillDate");
		                    	var newDate = date.setMonth(date.getMonth()-6);
		                    	newDate = new Date(newDate);
		                    	startDate.setMinValue(newDate);
		                    	endDate.isValid();
    						}
    					}
					}
				}]
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'programSearchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
