
Ext.define('Academia.view.attendance.attendancesettings.AttendanceSettings',{
	extend: 'Ext.window.Window',
	alias : 'widget.attendancesettings',
	title : 'Attendance Settings',
	modal:true,
	autoScroll: true,
	width:550,
	height:450,
	items : [{
	         xtype:'form',
	         method: 'POST',
	         defaults: {
	             labelAlign: 'top',
	         },
	         standardSubmit: false,
	         plugins:"formlabelrequired",
	         items:[{
	        	 xtype: 'fieldcontainer',
	        	 width: 'auto',
	        	 defaults: {
	        		 labelAlign: 'top',
	        		 width: 226
	        	 },
	        	 layout: {
	        		 type: 'hbox'
	        	 },
	        	 items : [{
				xtype: 'hidden',
				name: 'id'
			},{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyLocationId',
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationByName',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				queryParam:'name',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				forceSelection:true,
				triggerAction: '',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
        	 },{
        		 xtype : 'customcombobox',
        		 name : 'studentAttendaceType',
        		 itemId:'studentAttdndaceTypeID',
        		 fieldLabel : getProgramandcourseTranslation('STUDENT_ATTENDACE_TYPE'),
        		 store:'attendance.StudentAttendanceType',
        		 valueField : 'value',
        		 displayField : 'value',
        		 allowBlank : false
        	 }]
			},
			{
	        	 xtype : 'fieldcontainer',
	        	 //width : '100%',
	        	 layout : {
	        		 type : 'hbox'
	        	 },
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [{
						xtype : 'numberfield',
						name : 'sessionNo',
						itemId:'sessionNoId',
						fieldLabel : getProgramandcourseTranslation('NO_OF_SESSIONS'),
						allowBlank : false,
						minValue:1,
						maxValue:3,
						allowExponential :false,
						allowDecimals: false,
						hideTrigger:true,
						hidden: true,
						width : 226
					}]
		},
			
			{
	        	 xtype : 'fieldcontainer',
	        	 //width : '100%',
	        	 layout : {
	        		 type : 'hbox'
	        	 },
	        	 defaults : {
	        		 width : 226,
	        		 labelAlign : 'top'
	        	 },
	        	 items : [/*{
	        		 xtype : 'customcombobox',
	        		 name : 'facultyAttendanceType',
	        		 fieldLabel : getProgramandcourseTranslation('FACULTY_ATTENDANCE_TYPE'),
	        		 store:'attendance.StudentAttendanceType',
	        		 valueField : 'value',
	        		 displayField : 'value',
	        		 allowBlank : false
	        		 ,
						layout: 'hbox',
						items : [ {
							boxLabel : 'Yes',
							name : 'whetherAdhocRequired',
							inputValue : true
						}, {
							boxLabel : 'No',
							name : 'whetherAdhocRequired',
							inputValue : false,
							checked : true
						} ]
	        	 },*/{
	        		 xtype : 'customcombobox',
	        		 name : 'sortBy',
	        		 itemId:'sortBy',
	        		 fieldLabel : getProgramandcourseTranslation('ATTENDANCE_SORTING_TYPE'),
	        		 store:'attendance.AttendanceSortingStore',
	        		 valueField : 'value',
	        		 displayField : 'value',

	        	 },{
	        		 xtype : 'radiogroup',
	        		 fieldLabel : getProgramandcourseTranslation('FACULTY_CONFLICT_REQUIRED'),
	        		 itemId:'concurrentAttendanceAllowedId',
	        		 hidden:true,
	        		 width : 240,
	        		 defaults: {
	        			 flex: 1
	        		 },
	        		 layout: 'hbox',
	        		 items : [{
	        			 boxLabel : 'Yes',
	        			 name : 'concurrentAttendanceAllowed',
	        			 inputValue : true
	        		 }, {
	        			 boxLabel : 'No',
	        			 name : 'concurrentAttendanceAllowed',
	        			 inputValue : false,
	        			 checked : true
	        		 } ]
	        	 }]
		},{
			xtype : 'fieldcontainer',
			width: 'auto',
			fieldLabel : getProgramandcourseTranslation('BACKE_DATE_ALLOWED'),
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'numberfield',
				name : 'backedDateAllowed',
				fieldLabel : getProgramandcourseTranslation('CORE_ERP'),
				allowBlank : false,
				minValue:0,
				maxValue:365,
				allowExponential :false,
				hideTrigger:true
			},{
				xtype : 'numberfield',
				name : 'backDateAllowedForFaculty',
				fieldLabel : getProgramandcourseTranslation('FACULTY'),
				allowBlank : false,
				minValue:0,
				maxValue:365,
				allowExponential :false,
				hideTrigger:true
			}]
		},{
					xtype : 'fieldcontainer',
					// width : '100%',
					width: 'auto',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [/*{
						xtype : 'radiogroup',
						fieldLabel : getProgramandcourseTranslation('TIME_TABLE_PLANNING_FLAG'),
						itemId:'timeTablePlanningId',
						hidden: true,
						defaults: {
							flex: 1
						},
						layout: 'hbox',
						items : [ {
							boxLabel : 'Yes',
							name : 'timeTablePlanning',
							inputValue : true,
							checked : true
						}, {
							boxLabel : 'No',
							name : 'timeTablePlanning',
							inputValue : false
						} ]
					},*/{
		        		 xtype : 'customcombobox',
		        		 name : 'attendanceSlot',
		        		 itemId:'attendanceSlotId',
		        		 fieldLabel : getProgramandcourseTranslation('ATTENDANCE_SLOTS'),
		        		 store:'attendance.AttendanceSettingSlot',
		        		 valueField : 'id',
		        		 displayField : 'value',
		        		 allowBlank : false,
		        		 hidden: true,
					},{
						xtype : 'radiogroup',
						fieldLabel : getProgramandcourseTranslation('WHETHER_ADHOC_REQUIRED'),
						itemId:'adhocRequiredId',
						allowBlank : false,
						hidden: true,
						width : 240,
						height: 58,
						items : [ {
							boxLabel : 'Yes',
							name : 'whetherAdhocRequired',
							inputValue : true,
						}, {
							boxLabel : 'No',
							name : 'whetherAdhocRequired',
							inputValue : false,
							checked : true
						} ]
					}
					]
		},{
			xtype: 'fieldcontainer',
			defaults : {
				labelAlign : 'top'
			},
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'textfield',
					name: 'expiryTime',
					itemId: 'expirytime',
					fieldLabel: getCommonTranslation('EXPIRY_TIME'),
					labelStyle: 'font-weight:bold',
					placeholder: 'HH:mm:ss',
					hidden: true,
					allowBlank: true,
					plugins: [new Ext.ux.InputTextMask('99:99:99')],
					maskRe: /[0-9:]/,
					value: "00:00:00",
					validator: function(value) {
						if (!value) {
							return true;
						}

						var regex = /^\s*([01]?\d|2[0-3]):?([0-5]\d):?([0-5]\d)\s*$/;
						if (regex.test(value)) {
							return true;
						} else {
							return 'Allowed format: HH:mm:ss (Hours:Minutes:Seconds)';
						}
					},
					listeners: {
						blur: function(field) {
							if (Ext.isEmpty(field.getValue()) || field.getValue() ==  '__:__:__') {
								field.setValue("00:00:00");
							}
						}
					}
				}
				]
		},{

			        xtype: 'fieldcontainer',
			        defaults : {
						labelAlign : 'left'
					},
			        layout: {
			            type: 'hbox'
			        },
			        items: [{
			            xtype: 'checkbox',
			            labelWidth: 300,
			            itemId:'biometricAttendanceIntegrationRequireId',
			            name: 'biometricAttendanceIntegrationRequire',
			            hidden:true,
			            inputValue: true,
			            uncheckedValue:false,
			            checked:false,
			            boxLabel: getProgramandcourseTranslation('BIOMETRIC_ATTENDANCE_INEGRATION_REQUIRED'),
			            listeners: {
			                change : function( checkBox) {
			                	}
			            	}
				        }]
			    
				},{

			        xtype: 'fieldcontainer',
			        itemId:'rangeSessionId',
		        	hidden:true,
			        defaults : {
						width : 226,
						labelAlign : 'top'
					},
			        layout: {
			            type: 'hbox'
			        },
			        items: [{
			        	 xtype : 'numberfield',
		        		 name : 'punchAllowanceRange',
		        		 itemId:'punchAllowanceRangeId',
		        		 minValue:1,
		        		 fieldLabel : getProgramandcourseTranslation('PUNCH_ALLOWANCE_RANGE')
			        },{
			        	 xtype : 'numberfield',
		        		 name : 'beforeSessionStart',
		        		 minValue:1,
		        		 itemId:'beforeSessionStartId',
		        		 fieldLabel : getProgramandcourseTranslation('BEFORE_SESSION_START')  
				        	   
			        }]
			    
				},{

			        xtype: 'fieldcontainer',
			        itemId:'sessionPunchId',
	        		hidden:true,
			        defaults : {
						width : 226,
						labelAlign : 'top'
					},
			        layout: {
			            type: 'hbox'
			        },
			        items: [{
			        	 xtype : 'numberfield',
		        		 name : 'beforeSessionEnd',
		        		 minValue:1,
		        		 itemId:'beforeSessionEndId',
		        		 fieldLabel : getProgramandcourseTranslation('BEFORE_SESSION_END')
			        },{
			        	
			        	xtype: 'checkboxgroup',
			        	height : 82,
				        fieldLabel: getProgramandcourseTranslation('PUNCH_TYPE'),
				        itemId:'punchTypeId',
						name: 'punchType',
						
				        items:[{
				        	   boxLabel:getProgramandcourseTranslation('PUNCH_IN'),
				        	   inputValue : 'punchIn',
				        	   name:'punchType',
				        	   
				         },{
				        	   boxLabel:getProgramandcourseTranslation('PUNCH_OUT'),
				        	   inputValue : 'punchOut',
				        	   name:'punchType',
				        }]
			        }]
			    
				},{
					xtype: 'fieldcontainer',
					width: '100%',
					cls: 'windowBtnPos',
					items : [{
						xtype : 'button',
						text : getCommonTranslation('SAVE'),
						itemId : 'btnAdd',
						ui : 'CustomBtnSubmit',
						scale : CONSTANTS.BUTTONSIZE,
						formBind : true
					}, {
						xtype : 'button',
						text : getCommonTranslation('CANCEL'),
						itemId : 'btnCancel',
						ui : 'CustomBtnCancel',
						scale : CONSTANTS.BUTTONSIZE
					}]
			}]
	}]
		    	
});