/**
 * this window is used to change the AcademyLocation.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.baselayout.header.AcademyLocationChangeWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.academylocationchangewindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('CHANGE_ACADEMY_LOCATION'), // quota Details
    //translationKey : 'CHANGE_ACADEMY_LOCATION',
    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 346
        },
        items: [{
        	xtype:'hidden',
        	itemId: 'academyLocationId'
        },{
        	    xtype:'displayfield',
        	    itemId:'displayfieldItemId',
        	    fieldLabel: getCommonTranslation('CURRENT_ACADEMY_LOCATION'), //Academy Location
//        	    translationKey: 'CURRENT_ACADEMY_LOCATION'
            },{
        		xtype: 'customcombobox',        
        	    itemId: 'cmbGlobalAcademyLocation',
        	    fieldLabel: getCommonTranslation('ACADEMY_LOCATION'), //Academy Location
        	    store: 'scholarships.LogedInUserAcademyLocationStore',	    
        	    valueField: 'id',
        	    displayField: 'academyLocationName',
        	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
        	    //emptyText:getCommonTranslation('SELECT_ACADEMY_LOCATION'), //Select Academy Location
        	    editable: true,	    
        	    queryMode: 'local',	    
        	    triggerAction: 'all',
        	    labelAlign:'top',
        	    typeAhead:true,
        	    anyMatch : true,
        	    allowBlank: false,
        	    /*cls: 'headerComboBox',
        	    style:{
        	    	marginRight:'10px',
        	    	marginBottom:'10px'
        	    },*/
//        	    translationKey: 'ACADEMY_LOCATION',
        	    forceSelection: true
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
             style: {
            	marginLeft : '-2px',
            	marginTop : '11px'
            },
            items: [{
                xtype: 'button',
                itemId: 'btnSaveALChangeWindow',
                text: getCommonTranslation('SAVE'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
//                translationKey: 'SAVE',
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelChangeALWindow',
                text: getCommonTranslation('CANCEL'), //Cancel
                ui: 'CustomBtnCancel',
//                translationKey: 'CANCEL',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                	click: function() {
                		this.up('window').close();
                	}
                }
            }]
        }]
    }]

});