/**
 * @author prathamesh.sheth
 *  
 * Notification/Alert window screen.
 * 
 */	   
Ext.define('Academia.view.baselayout.header.NotificationAlertWindow',
{
		extend : 'Ext.window.Window',
		alias : 'widget.notificationalertwindow',
		id:'NotificationAlertWindow',
		header: false,
		resizable:false,
		height:400,
		
		bodyStyle: {
		    margin: '0',
		    padding: '0px !important',
		    background:'#fff'
		},
		border:true,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			itemId:'notificationId',
			width:'100%',
			style:{'border-bottom':'1px solid #ddd'},
			items:[{
				xtype:'component',					
				itemId : 'headerRegion',
				width: 340,
				region:'north',
				style:{
					display:'table'
				},
				renderTpl: ['<div style="display:table-cell;vertical-align:middle;text-align:left;text-decoration:none;background:#ffffff;padding:10px;"><div style="padding: 10px; font-weight:bold;"><span>{unreadCount}</span><span style="margin-left: 2px;">{type}</span></div></div>'],
				data: {
					type:'',
					unreadCount: "0"
				},				
				renderSelectors: {
					spanEl1: 'span',
					spanEl2: 'span[style]'
				},				
				childEls: ["unreadCount"]
				
			},{
				xtype:'button',					
				itemId:'viewAllSection',
				margin:'18 0 0 0',
				ui : 'CustomBtnSubmit',
				height:22,
				text:getCommonTranslation('VIEW_ALL_NOTIFICATIONS'),
				style:{
					"padding": "1px 3px 3px 3px !important"
				}
			}]
		},{
			xtype:'fieldcontainer',
			overflowY: 'auto',      
		    reserveScrollbar:true,
		    cls:'horizontalScrollingFixed',
			itemId:'alertId',
			height:400,
			width:'auto',
			defaults: {
				width: 400
			},
			items:[
				{
		        xtype:'notificationalerttemplate',            
		        itemId : 'notificationAlertTemplateRegion',
		    }]
		}]
});