Ext.define('Academia.view.baselayout.megamenu.VerticalNavigationMenuButton',{
	extend:'Ext.button.Button',
	alias:'widget.verticalnavigationmenubutton',
		cls:'menu-button',
		scale:'medium',
		textAlign: 'left',
		showEmptyMenu: false,
		focusCls: 'blankFocus', // V2D-33234
		menuAlign: 'tr',
		menu:{
		        items: []
			},
		
	initialize:function(menuItem){
		this.index=menuItem.displayOrder;
		this.displayCode =menuItem.displayCode;
		
		var oldNewIconClsMapping = {
		    'ph-megaphone'          : 'campaign',
		    'ph-folder-simple-user' : 'admissions',
		    'ph-student': 'students',
		    'ph-books': 'courses',
		    'ph-wallet': 'feesandpayments',
		    'ph-hand-coins': 'scholarships',
		    'ph-exam': 'examinations',
		    'ph-flag': 'completion',
		    'ph-book-open-user': 'outcomebasededucation',
		    'ph-users-four': 'systemAdmin',
		    'ph-user-focus': 'faculties',
		    'ph-gear': 'setup',
		    'ph-chat': 'survey',
		    'ph-van': 'transport',
		    'ph-bed': 'hostel',
		    'ph-headset': 'complaintManagement',
		    'ph-first-aid-kit': 'infirmaryManagement',
		    'ph-list-magnifying-glass': 'placement',
		    'ph-folder-star': 'fileManagement'
		};

		if (menuItem.iconCls) {
		    // loop through the keys of the mapping
		    Ext.Object.each(oldNewIconClsMapping, function(oldCls, newCls){
		        if (menuItem.iconCls.indexOf(oldCls) !== -1) {
		            menuItem.iconCls = newCls;
		            return false; // stop loop once match found
		        }
		    });
		}
		
		this.iconCls=menuItem.iconCls;
		this.cls+=" "+menuItem.menuColorCls;
		this.text= getMenuDisplayName(menuItem.displayCode);
		this.setTooltip(this.text);
		var menuPanel;
		if(menuItem.systemMenuHierachyModel){
			menuPanel=Ext.create('Academia.view.baselayout.megamenu.VerticalNavigationMenuPanel');
			menuPanel.initialize(menuItem.systemMenuHierachyModel);
			this.menu.insert(menuPanel);
			this.menu.addCls('megaMenuPanel');
			this.menu.addCls(menuItem.menuColorCls);
		}
	},
	
});