/**
 * @author Abhishek Chouhan
 * This component is used for to Assign Work Calendar   for Employee
 */
Ext.define('Academia.view.calendar.AssignWorkCalendarWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.assignworkcalendarwindow',
    modal: true,
    title: getCommonTranslation('ASSIGN_WORK_CALENDAR'),
    items: [{
        xtype: 'form',
        itemId: 'assignworkcalendar',
        method: 'POST',
        margin: 0,
        bodyPadding: '10 10 10 10',
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'hidden',
                name: 'id',
                itemId: 'id',
            }, {
                xtype: 'hidden',
                name: 'assignCalendarId',
                itemId: 'assignCalendarId',
            }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('CALENDAR'),
                name: 'calendarId',
                valueField: 'id',
                displayField: 'value',
                itemId: 'calendarId',
                store: 'calendar.ActiveStaffCalendarStore',
                editable: false,
                allowBlank: false,
                queryMode: 'local',
            }, {
                xtype: 'datefield',
                name: 'startDate',
                itemId: 'startDate',
                fieldLabel: getServiceRequestTranslation('START_DATE'),
                editable: true,
                allowBlank: false,
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
                vtype: 'daterange',
                endDateField: 'endDate',
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                    }
                }
            }, {
                xtype: 'datefield',
                name: 'endDate',
                itemId: 'endDate',
                fieldLabel: getServiceRequestTranslation('END_DATE'),
                editable: true,
                allowBlank: false,
              //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
                vtype: 'daterange',
                startDateField: 'startDate',
                listeners: {
                    render: function(obj) {
                        obj = dateFormatRender(obj);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveEmployeeCalendar',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});