/**
 * This window is used for copy work time to other day
 */

Ext.define('Academia.view.calendar.worktimingconfiguration.CopyWorkTimeConfigWindow',{
	extend : 'Ext.window.Window',
	alias : 'widget.copyworktimeconfigwindow',			
	modal : true,
	resizable:false,
	title : getCommonTranslation('COPY_WORK_TIME_DETAILS_TO_DAY'),		
	items : [{
		xtype: 'form',
		itemId:'copyWorkTimeForm',
	    plugins : "formlabelrequired",
		defaults:{
			labelAlign:'top',
			width: 226
		},
	    standardSubmit : false,
	    items : [{
    	  	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('SELECT_DAY_TO_COPY'),
            name: 'weekday',
            valueField: 'name',
            displayField: 'value',
            itemId: 'weekday',
            store: 'common.DayWiseWeekComboStore',
            editable: false,
            allowBlank: false,
            queryMode: 'local',
            listeners: {
            	beforerender: function(combo){
            		var store = Ext.create('Academia.store.common.WeekDaysComboStore');
            		combo.bindStore(store);
            	}
            }
		}, {
        	xtype:'fieldcontainer',
        	width:'100%',
        	cls:'windowBtnPos',
            style: {
                marginLeft: '-3px'
            },
            items: [{
				xtype : 'button',				
				itemId:'btnCopySelectedDayConfig',
				text : getCommonTranslation('SAVE'),
				ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
			},{
				xtype : 'button',
				itemId:'btnCancelCopySelectedDayConfig',
				text : getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
			}]
	    }]
	}]			
});