/**
 * This is used campaign for pie chart report
 * @author Rajkumar.patidar
 */
Ext.override(Ext.chart.series.Pie, {
	getLegendColor: function(index) {
		var me = this;
        var store = me.chart.substore || me.chart.store;
        var record = store.getAt(index);
        /**
         * below color array need be exactly same as defined in series renderer function
         * */
//		var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A"][record.get("id")];
        var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    	var color = baseController.getRandomColor(record.get("id"));
		if(color)
			return color;
		else
			return '#669900';
	}
});

Ext.define('Academia.view.campaign.dashboard.CampaignDashBoardChart' ,{
	extend: 'Ext.chart.Chart',
	alias : 'widget.campaigncashcoardchart',
	animate: false,
	shadow: false,
	legend: {
		position: 'bottom'
	},
	insetPadding: 20,
	theme: 'Base:gradients',
	initComponent: function() {
		var this$ = this;
		var numberField = !isNullOrEmpty(this.numericField)?this.numericField:'number';
		var categoryField = !isNullOrEmpty(this.categoryField)?this.categoryField:'category';
		var chartStore = null;
		if(!isNullOrEmpty(this.store)){
			chartStore = Ext.create(this.store);
		}else{
			chartStore = Ext.create('Ext.data.JsonStore',{
				fields: ['number', 'category'],
				data: [{
					number :0,
					category : 'Category'
				}]
			});
		}
		Ext.apply(this$, {
			store: chartStore,
			series: [{
				type: 'pie',
				field: numberField,
				showInLegend: true,
				donut: false,
				tips: {
					trackMouse: true,
					width: 250,
					height: 28,
					renderer: function(storeItem, item) {
						//calculate percentage.
						var total = 0;
						chartStore.each(function(rec) {
							total += rec.get(numberField);
						});
						this.setTitle(storeItem.get(categoryField));
					}
				},
				/*highlight: {
					segment: {
						margin: 0
					}
				},*/
				label: {
					field: categoryField,
					display: 'insideEnd',
					'text-anchor': 'middle',
					contrast: false,
					 font: 'bold 16px Arial,Helvetica, sans-serif',
					renderer: function(value, label, storeItem) {
						return storeItem.get('count');
					}
				},
				style: {
					'stroke-width': 0,
					'stroke': '#fff'
				},
				renderer: function(sprite, record, attr, index, store) {
					/**
			         * below color array need be exactly same as defined in override getLegendColor function
			         * */
					var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A"][record.get("id")];
					return Ext.apply(attr, {
						fill: color
					});
				}
			}],
			listeners: {
		        afterrender: function(view){
		            Ext.each(view.legend.items, function(item) {
		                item.un("mousedown", item.events.mousedown.listeners[0].fn);
		            });
		        }
		    }
		});

		this$.callParent(arguments);
	}
});

