
Ext.define('Academia.view.campaignnew.LeadsCapturedGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leadscapturedgrid',
    store: 'campaignnew.LeadsCapturedStore',
    title: getCommonTranslation('MANAGE_CAMPAIGN_LEADS_CAPTURED'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'campaignnew.LeadsCapturedStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [],
    columns: [{
        header: getCommonTranslation('ENQUIRY_ID'),
        dataIndex: 'code',
        flex: 1,
    	sortable:false,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)){
				return '<a href=#>'+value+'</a>';
			}
			else{
				return '-';
			}
		}
    }, {
        header: getCommonTranslation('ENQUIRER_NAME'),
        dataIndex: 'printName',
        flex: 1,
        sortable: true
    }]
});