/**
 * @author Harshit Satya
 */
Ext.define('Academia.view.committee.committee.BulkMembershipUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.bulkmembershipuploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype:'bulkmembershipuploadoptionradiogroup',
		width: 500,
        margin: 0,
		itemId:'membershipUploadOptionRadioGroupItemId',
	},{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleBulkMemName',
		store:'importutility.ModuleName',
		/*store:  Ext.create('Ext.data.Store', {
	        fields: ['id', 'value'],
	        data: [
	            { id: 1, value: getCommonTranslation('BULK_MEMBERSHIP_CREATION') }
	        ]
	    }),*/
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
		readOnly:true,
		value: 1
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 460,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadBulkMemFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'bulkMemUploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtnBulkMem', 
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
