/**
 * @Author Akshay.Kalbhor
 * Used within the Organization-info tab for the settings combo boxes.
 * cant change to generic as the data formed in the getSubmitData Function
 *  returns data specific to the "organizationSettings" 
 */

Ext.define('Academia.view.common.SettingsCombo', {
    extend : 'Ext.form.field.ComboBox',
    alias : 'widget.settingCombo',
    valueField: 'name',
    displayField: 'name',
    settingId: null,
    settingName: null,
    /**
     * SettingId SettingName
     * Use this function if you want the nested settings object sent in the save request
     * eg: "setting": {
                "id": 1,
                "fieldName": "df"
            },
            "value": "MDY"
     * 
     */
    getSettingData:function(){
		var dataValue = new Object();
		dataValue.setting = new Object();
		dataValue.setting.id = this.settingId;
		dataValue.setting.fieldName=this.settingName;// settingName
		dataValue.value = this.getValue();
		return dataValue;
    },

    getSubmitData: function() {
    	var me = this,
		data = null,
		value;
		if (!me.disabled && me.submitValue && !me.isFileUpload()) {
		    value = me.getValue();
		    if (value !== null) {
				var dataValue = new Object();
				var organizationSettings = new Object();
				var setting = new Object();
				setting.id = this.settingId;
				setting.fieldName=this.settingName;// settingName
				dataValue.setting=setting;
				dataValue.value = value;
				organizationSettings.organizationSettings=dataValue;
				data=organizationSettings;	
		    }
		}
		return data;
    }

});