/**
 *  @author pritam.patil
 *  Transfer General TAb Form 
 */
Ext.define('Academia.view.completion.completionlistforms.TransferGeneralForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.transfergeneralform',
    frame: false,
    border: false,
    autoScroll: true,
    items: [{
        xtype: 'fieldset',
        collapsed: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            plugins: "formlabelrequired",
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            style :{
	        	marginTop : '-5px',
	        	marginLeft : '9px'
	        },
            items: [{
    			xtype :'hidden',
    			name : 'id'
    		},{
    			xtype : 'hidden',
    			name : 'version'
    		},{
                xtype: 'datefield',
                fieldLabel: getCompletionModuleTranslation('TRANSFER_EFFECTIVE_DATE_FROM'),
                disabled : true,
                name: 'effectiveDate',
                itemId: 'startDate',
                allowBlank: false,
                minValue : new Date(),
                editable : false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
            },{
                xtype: 'nestedJsonCombo',
                fieldLabel: getServiceRequestTranslation('TRANSFERING_REASON'),
                store: 'servicerequest.TransferReasons',
                name : 'reason',
                valueField: 'id',
                itemId: 'transferReason',
                displayField: 'value',
                allowBlank: false,
                readOnly : true,
                editable: false
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            style :{
	        	marginTop : '-5px',
	        	marginLeft : '9px'
	        },
            layout: 'vbox',
            items: [{
                xtype: 'textareafield',
                name: 'remark',
                itemId : 'transferRemark',
                width: 400,
                readOnly : true,
                fieldLabel: getCompletionModuleTranslation('TRANSFERING_REMARKS')
            },{
                xtype: 'textfield',
                width: 300,
                labelAlign: 'top',
                name: 'approvedBy',
//              allowBlank: false,
                readOnly : true,
                fieldLabel: getCompletionModuleTranslation('APPROVED_BY'),  
                itemId: 'approvedById'
            }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style :{
        	marginTop : '10px',
        	marginLeft : '6px'
        },
        items: [{
            xtype: 'button',
            itemId: 'transferGeneralSubmitBtn',
            text: getCompletionModuleTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            disabled : true
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            name : 'transferGeneralCancelBtn',
            itemId: 'generalCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]
});
