/**
 * By Utsav
 */
Ext.define('Academia.view.course.courseComponent.CourseComponentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursecomponentsgrid',
    store : 'course.coursecomponent.CourseComponentStore',
	title : getCommonTranslation('COURSE_COMPONENTS'),
	cls:'horizontalScrollingFixed',
	border: true,
	/*sortableColumns:false,
	enableColumnHide: false,
	enableColumnMove: false,
	enableColumnResize: false,*/
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
		    store : 'course.coursecomponent.CourseComponentStore',
		    displayInfo : true
		} ]
	    }
	    ],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH	
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [/*{
		header : 'ID',
		hidden : true,
		dataIndex:'id'
	},*/{
		header : getCommonTranslation('COURSE'),
		hidden : true,
		dataIndex:'course',
		renderer : function(value){
			return value.code;
		}
	},{
		
		header : getCommonTranslation('COURSE_COMPONENT'),
		dataIndex : 'componentType',
		flex : 1,
		renderer : function(value){
			if(value!=null){
			return value.value;
		}}
		 
	}, {
		header : getCommonTranslation('DESCRIPTION'),
		dataIndex : 'componentDesc',
		flex : 1	
		
	}, {
		header : getCommonTranslation('CREDITS'),
		dataIndex : 'componentCredit',
		flex : 1
	}, {
		header : getCommonTranslation('STATUS'),
		dataIndex : 'componentStatus',
		flex : 1,
		renderer : function(value){
			if(value){
				return getCommonTranslation('ACTIVE');
			}else{
				return getCommonTranslation('INACTIVE');
			}
		}
	}
	]

});
