/**
 * @author anshu.singh
 */
Ext.define('Academia.view.course.coursegroup.CourseCreditGradeReportsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.coursecreditgradereportsgrid',
  
    store: 'course.coursegroup.CourseCreditGradeReportGridStore',
    title: getCommonTranslation('COURSE_CREDIT_GRADE_REPORT'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'course.coursegroup.CourseCreditGradeReportGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
    columns: [{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable: true,
        flex: .2,
		
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: true,
        flex: .2,
		
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable: true,
        flex: .2,
		
    },  {
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        sortable: true,
        flex: .2,
		
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        sortable: true,
        flex: .2,
		
    }, {
        header: getCommonTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantDescription',
        sortable: true,
        flex: .2,
		
    }, {
        header: getCommonTranslation('COURSE_CREDIT'),
        dataIndex: 'courseCredit',
        sortable:true,
        flex: .2,
		
    },{
        header: getCommonTranslation('WEIGHT_GPA'),
        dataIndex: 'weightGPA',
        sortable:true,
        flex: .2,
		
    },{
        header: getCommonTranslation('COURSE_MARK_GRADES'),
        dataIndex: 'courseMarksGrades',
        sortable: true,
        flex: .2,
		
    },{
        header: getCommonTranslation('GRADE_TYPE'),
        dataIndex: 'courseGradeType',
        sortable: true,
        flex: .2,
		
    },{
        header: getCommonTranslation('MIN_MARKS_GRADE'),
        dataIndex: 'courseCutOff',
        sortable: true,
        flex: .2,
		
    },{
        header: getCommonTranslation('MAX_MARKS_GRADE'),
        dataIndex: 'courseMaxMark',
        sortable: true,
        flex: .2,
		
    },{
        header: getProgramandcourseTranslation('FACULTY'),
        dataIndex: 'faculty',
        sortable: true,
        flex: .2,
		
    }, {
    	header : getCommonTranslation("COURSE_SEQUENCE"),
		dataIndex: 'courseSequence',
        sortable: true,
        flex: .2,
		
        hidden: true
    }]

});