/**
 * @author Ravi Choudhary 
 */
Ext.define('Academia.view.course.coursespecialization.CourseAssociatedToSpecailizationCourseGroups', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.courseassociatedtospecailizationcoursegroups',
	//resizable:true,
	autoScroll: false,
	cls:'horizontalScrollingFixed',
	border:true,
	title:getProgramandcourseTranslation('COURSES_ASSOCIATED'),
	store : 'course.coursespecialization.SpecializationCourseGroupCoursesStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.coursespecialization.SpecializationCourseGroupCoursesStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;      
		Ext.apply(grid, {
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: 'course.coursespecialization.SpecializationCourseGroupCoursesStore',
					emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
					displayInfo: true
				}]
			}]
		});

		grid.addExportToolBarItems(grid);
		grid.callParent(arguments);     
	},
	
	columns : [{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'value',
		flex : 1
	},{
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'code',
		flex : 1
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'secondValue',
		flex : 1
	},{
		header : getCommonTranslation('OPTIONAL_OR_MANDATORY'),
		dataIndex : 'check',
		flex : 1,
		renderer : function(value) {
			if (value == null) {
				return "-";
			} else if (value) {
				return value = getCourseTxCommonTranslation('MANDATORY');
			} else {
				return value = getCourseTxCommonTranslation('OPTIONAL');
			}
		}

	}]

});